<?php
// pages/wizard/step_newsletter.php
?>
<div class="space-y-6">
  <div class="flex items-center justify-between">
    <h2 class="text-xl font-semibold">Send a newsletter</h2>
    <button class="text-sm text-brand-600 hover:underline"
            hx-get="<?= \Components\Router::url('wizard_step_goal', ['partial' => 1]); ?>"
            hx-target="#wizard-body"
            hx-swap="innerHTML">Back</button>
  </div>
  <p class="text-gray-600 dark:text-gray-300">Who would you like to reach? You can start broad and refine later.</p>

  <form id="newsletter-audience" class="space-y-4" onsubmit="return false;">
    <div class="space-y-2">
      <label class="flex items-center gap-2">
        <input type="radio" name="audience" value="all" class="size-4" checked>
        <span>All customers</span>
      </label>
      <label class="flex items-center gap-2">
        <input type="radio" name="audience" value="segment" class="size-4">
        <span>A specific segment</span>
      </label>
      <div class="pl-6">
        <label for="segment" class="block text-sm text-gray-700 dark:text-gray-300 mb-1">Choose a segment</label>
        <select id="segment" name="segment" class="w-full rounded border border-gray-300 dark:border-white/10 bg-white dark:bg-gray-800 px-3 py-2 text-sm">
          <option value="inactive_90">Inactive: no order in 90 days</option>
          <option value="vip">VIP customers</option>
          <option value="new">New customers</option>
        </select>
      </div>
    </div>

    <div class="pt-2 flex items-center gap-3">
      <button class="inline-flex items-center px-3 py-2 text-sm font-medium text-white bg-brand rounded hover:bg-brand-700"
              hx-get="<?= \Components\Router::url('newsletter', ['partial' => 1]); ?>"
              hx-target="#app-container"
              hx-swap="innerHTML"
              hx-push-url="<?= \Components\Router::url('newsletter'); ?>">
        Next: Compose Newsletter
      </button>
      <span class="text-xs text-gray-500">You can change the audience in the editor before sending.</span>
    </div>
  </form>
</div>
