<?php
// pages/wizard/step_remarketing.php
require_once BEEZUI_ROOT . '/components/index.php';

use Components\ModuleLoader;
use Components\Base;

$groups = ModuleLoader::campaignsByGroup();
$groupNames = array_keys($groups);
?>
<div class="space-y-6">
  <div class="flex items-center justify-between">
    <h2 class="text-xl font-semibold">Choose a target area</h2>
    <button class="text-sm text-indigo-600 hover:underline"
            hx-get="<?= \Components\Router::url('wizard_step_goal', ['partial' => 1]); ?>"
            hx-target="#wizard-body"
            hx-swap="innerHTML">Back</button>
  </div>
  <p class="text-gray-600 dark:text-gray-300">What part of the customer journey do you want to improve? We’ll show you the relevant modules.</p>

  <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
    <?php foreach ($groupNames as $g): ?>
      <button class="group rounded-lg border border-gray-200 dark:border-white/10 p-4 text-left hover:border-indigo-300 hover:shadow-sm focus:outline-none focus:ring-2 focus:ring-indigo-500"
              hx-get="<?= \Components\Router::url('trigger', ['partial' => 1, 'group' => $g]); ?>"
              hx-target="#app-container"
              hx-swap="innerHTML"
              hx-push-url="<?= \Components\Router::url('trigger', ['group' => $g]); ?>">
        <div class="font-medium mb-1"><?php echo Base::h($g); ?></div>
        <p class="text-sm text-gray-600 dark:text-gray-300">Show modules for this target area.</p>
      </button>
    <?php endforeach; ?>
  </div>
</div>
