<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

  rewrite emails to add tracking code

  $ga = new analyticsEconda('medium', 'campaign', 'source');
  $nInfo->content = $ga->rewriteContent($nInfo, 'content');

  // or
  $ga = new analyticsEconda($medium, $campaign, $source);
  $content = $ga->rewriteContent($content);
 */

///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/analytics_base.php');


class analyticsPiwik extends analyticsBase
{

// class constructor
    function __construct($campaign = null, $keyword = 'module')
    {
        parent::__construct();
        if (is_null($campaign)) {
            $campaign = mh_cfg('MAILBEEZ_MAILHIVE_PIWIK_CAMPAIGN');
        }

        $this->code = '';
        $this->campaign = $campaign;
        $this->keyword = $keyword;
        $this->buildCode();
        $this->rewrite_format = mh_cfg('MAILBEEZ_MAILHIVE_PIWIK_REWRITE_FORMAT');
    }

    function buildCode()
    {
        // http://piwik.org/docs/tracking-campaigns-url-builder/
        // http://shop.com/?pk_campaign=mailbeez&pk_kwd=winback
        $this->code = 'pk_campaign=' . urlencode($this->campaign) . '&pk_kwd=' . urlencode($this->keyword);
    }

}
