<?php

// wrapper class for compatibility
// to avoid issues where modules are updated before framework


// PHP 5.3+
//if (function_exists('array_replace')) {
if (version_compare(PHP_VERSION, '5.3.0') >= 0) {
    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/Html2Text.php');


    class html2text
    {
        function __construct($html)
        {
            $options = array(
                'do_links' => 'inline', // 'none'
                // 'inline' (show links inline)
                // 'nextline' (show links on the next line)
                // 'table' (if a table of link URLs should be listed after the text.

                'width' => 70,          //  Maximum width of the formatted text, in columns.
                //  Set this value to 0 (or less) to ignore word wrapping
                //  and not constrain text to a fixed-width column.
            );

            $this->html = new MB_Html2Text($html, $options);
        }

        function html2text($html) {
            self::__construct($html);
        }


        function get_text()
        {
            return $this->html->getText();
        }
    }
} else {
    // use old version w/o namespace
    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/dprec_class.html2text.php');
}
