<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

  v2.3
 */


///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez_mailer.php');
require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/googleanalytics.php');
require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/compatibility.php');


class dashboardbeez extends beez
{

    var $pathToCommonTemplates;
    var $pathToMailbeez;
    var $code;
    var $module;
    var $versionScope = 'MAILBEEZ_DASHBOARD_INSTALLED_VERSIONS';

    var $jsLoadFunctionName = 'loadWidget';
    var $widget_module_id = '';

// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = ''; // unique id for report-module
        $this->module = ''; //
        $this->required_mb_version = 2.0;
        $this->title = '';
        $this->description = '';
        $this->sort_order = '';
        $this->enabled = '';
        $this->admin_action_plugins_path = MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'filterbeez/'; // default-path to include admin action plugins from
        $this->admin_action_plugins = ''; // list of admin frontend action plugins ("file1;file2")
        $this->common_admin_action_plugins = ''; // list of common gui plugins ("file1;file2")
        $this->icon = '../../common/images/icon_module.png';
        $this->description_image = '../../common/images/icon_module_64.png';
        $this->documentation_root = 'https://www.mailbeez.com/documentation/dashboardbeez/';
        $this->documentation_key = '';
        $this->hidden = false; // hide submodule / module
        $this->is_configurable = true;
        $this->removable = true;

        $this->session_cache_time = 15 * 60; // cache time in sec // todo: make configurable
        $this->app_cache_time = 15 * 60; // cache time in sec // todo: make configurable

        $this->ajaxEntryPoint = str_replace('&amp;', '&', mh_href_link(FILENAME_MAILBEEZ, 'app=load_app&app_path=config_dashboard/admin_application_plugins/ajax.php'));
        // fix issue on modified shop where & is converted into &amp; by href_link
    }


// class methods

    function getOutput()
    {

        if ($cache = $this->read_cache('app', true)) {
            $content = $this->getOutputAjax();
            if (isset($cache['expired'])) {
                $content .= $this->getOutputAjaxLoader();
            }
        } else {

            $id = $this->cache_id;
            $ref = $this->cache_reference;
            $content = "not found $id $ref";

            $content = $this->getOutputAjaxLoader();
        }

        return $content;

    }

    function generateData()
    {
        // implement in class
        return false;
    }

    function generateOutput($ajax = false, $refresh = false)
    {
        // implement in class
        return false;
    }


    function getOutputAjaxLoader()
    {
        // return javascript code to make Ajax Call;
        ob_start();
        ?>
        <script type="text/javascript">
            <?php echo $this->jsLoadFunctionName?>('<?php echo $this->ajaxEntryPoint; ?>', '<?php echo $this->module; ?>', 'load', <?php echo $this->app_cache_time; ?>, '<?php echo $this->widget_module_id; ?>');
        </script>
        <?php
        $output = ob_get_contents();
        ob_end_clean();

        return $output;
    }

    function getOutputAjax($clearcache = false)
    {
        if ($clearcache) {
            $this->purge_cache();
        }
        $content = $this->generateOutput(true, $clearcache);

        $content = $this->getCacheInfoHeader($clearcache) . $content;
        return $content;
    }


    function getCacheInfoHeader($clearcache)
    {
        ob_start();

        $cache_timestamp = $this->get_timestamp();
        $cache_timestamp_out = date('Y-m-d G:i:s', $cache_timestamp);

        ?>
        <div class="dashboader_widget_cache_control"
             onclick="<?php echo $this->jsLoadFunctionName?>('<?php echo $this->ajaxEntryPoint; ?>', '<?php echo $this->module; ?>', 'refresh', '', '<?php echo $this->widget_module_id; ?>');  if (event.stopPropagation) {
                   event.stopPropagation();   // W3C model
               } else {
                   event.cancelBubble = true; // IE model
               };">
            <abbr class="timeago" title="<?php echo $cache_timestamp_out; ?>"><?php echo $cache_timestamp_out; ?></abbr>
            <img
                src="<?php echo mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH'); ?>configbeez/config_dashboard/images/reload_icon.png"
                width="12" height="12" align="absmiddle">
        </div>

        <?php if ($clearcache) { ?>
        <script type="text/javascript">
            jQuery(document).ready(function () {
                jQuery("#<?php echo $this->module ?> .ceebox").ceebox({overlayOpacity:0.2, animSpeed:1, fadeIn:10, fadeOut:1, easing:'linear', titles:false, borderColor:'#666' });
                jQuery.timeago.settings.allowFuture = true;
                jQuery("#<?php echo $this->module ?> abbr.timeago").timeago();
            });
        </script>
        <?php } ?>

        <?php
        $output = ob_get_contents();
        ob_end_clean();

        return $output;
    }

    function addAjaxEntryPointParam($param)
    {
        $this->ajaxEntryPoint = $this->ajaxEntryPoint . $param;
        return true;
    }

}

// end of class
