<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

  v2.3
 */


///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/dashboardbeez.php');
require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez_analytics.php');


class dashboardbeez_analytics extends dashboardbeez
{

    var $selected_module = null;
    var $selected_module_base = null;
    var $selected_module_iteration = null;
    var $selected_module_iteration_loopstart = null;
    var $selected_campaign = null;
    var $selected_campaign_item = null;
    var $selected_campaign_item_ids = null;
    var $start_date_db = null;
    var $end_date_db = null;
    var $filterparam = null;
    var $widget_mode = false;
    var $leaderboard_include = false;


// class constructor
    function __construct()
    {
        parent::__construct();

    }

    function set_date_frame($start_date, $end_date)
    {
        if ($start_date != '') {
//            echo $start_date;
            $start_date_db = mailbeez_system::convert_realdate_to_db($start_date);
            if (mailbeez_system::is_valid_db_date($start_date_db)) {
                $this->start_date_db = $start_date_db;
                $param = '&selected_startdate=' . $start_date;
                $this->addAjaxEntryPointParam($param);
                $this->addFilterparam($param);
            }
        }

        if ($end_date) {
            $end_date_db = mailbeez_system::convert_realdate_to_db($end_date, true);
            if (mailbeez_system::is_valid_db_date($end_date_db)) {
                $this->end_date_db = $end_date_db;
                $param = '&selected_enddate=' . $end_date;
                $this->addAjaxEntryPointParam($param);
                $this->addFilterparam($param);
            }
        }
    }

    function set_selected_module($module_id)
    {
        if ($module_id != '') {
            $this->selected_module = $module_id;
            $param = '&selected_module=' . $this->selected_module;
            $this->addAjaxEntryPointParam($param);
            $this->addFilterparam($param);

            if (stristr($module_id, '-')) {
                if (stristr($module_id, '-loop')) {
                    list($this->selected_module_base, $this->selected_module_iteration, , $this->selected_module_iteration_loopstart) = explode('-', $module_id);
                } else {
                    list($this->selected_module_base, $this->selected_module_iteration) = explode('-', $module_id);
                }
            } else {
                $this->selected_module_base = $module_id;
            }
        }
    }

    function set_selected_campaign($campain_id)
    {
        $this->selected_campaign_item_ids = 0;
        if ((int)$campain_id > 0) {
            $this->selected_campaign = (int)$campain_id;
            $param = '&selected_campaign=' . $this->selected_campaign;
            $this->addAjaxEntryPointParam($param);
            $this->addFilterparam($param);


            require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'mailbeez/mb_newsletter/classes/mb_newsletter_analytics.php');

            $mb_nl_analytics = new mb_newsletter_analytics();
            $mb_nl_analytics->set_campaign_id($this->selected_campaign);
            $mb_nl_analytics->set_campaign_item_id($this->selected_campaign_item);

            $data = $mb_nl_analytics->get_campaign_items_ids();

            if ($data) {
                $this->selected_campaign_item_ids = implode(',', $data);
            }

        }
    }

    function set_selected_campaign_item($campain_item_id)
    {
        if ((int)$campain_item_id > 0) {
            $this->selected_campaign_item = (int)$campain_item_id;
            $param = '&selected_campaign_item=' . $this->selected_campaign_item;
            $this->addAjaxEntryPointParam($param);
            $this->addFilterparam($param);
            $this->selected_campaign_item_ids = (int)$campain_item_id;
        }
    }


    function set_widget_mode($mode)
    {
        $this->widget_mode = $mode;
        $param = '&widget_mode=' . $this->widget_mode;
        $this->addAjaxEntryPointParam($param);
    }

    function set_widget_module_id($id)
    {
        $this->widget_module_id = $id;
        $param = '&widget_module_id=' . $this->widget_module_id;
        $this->addAjaxEntryPointParam($param);
    }

    function set_leaderboard_include($value)
    {
        $this->leaderboard_include = $value;
        $param = '&leaderboard_include=' . $this->leaderboard_include;
        $this->addAjaxEntryPointParam($param);
    }


    function _set_cache_id()
    {
        $this->set_cache_id($this->module, md5(implode('|', array($this->selected_module, $this->selected_campaign, $this->selected_campaign_item, $this->start_date_db, $this->end_date_db, $this->widget_mode, $this->widget_module_id, MAILBEEZ_SIMULATION_ID))));
    }


    function addFilterparam($param)
    {
        $this->filterparam .= $param;
    }

}

// end of class
