<?php

// https://github.com/joshcam/PHP-MySQLi-Database-Class
require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/vendor/joshcam/PHP-MySQLi-Database-Class/MysqliDb.php');

class mailbeez_db extends MysqliDb
{

    function __construct($host = null, $username = null, $password = null, $db = null, $port = null, $charset = 'utf8')
    {
        parent::__construct($host, $username, $password, $db, $port, $charset);
    }

    function indexExists($table, $index_column)
    {
        $query_raw = "SHOW INDEX FROM " . $table . "";
        $cols = $this->query($query_raw);
        foreach ($cols as $col) {
            if ($col['Column_name'] == $index_column) {
                return true;
            }
        }
        // not found
        return false;
    }

    function addIndex($table, $index_column) {
        $sql = "ALTER TABLE " . $table . " ADD INDEX ( $index_column )";
        return $this->query($sql);
    }

    function checkOrAddIndex($table, $index_column) {
        if (!$this->indexExists($table, $index_column)) {
            return $this->addIndex($table, $index_column);
        }
        return true;

    }

}