<?php

//use Gambio\Core\Configuration\ConfigurationService;


if (function_exists('zen_redirect')) {
    mh_define('MH_PLATFORM', 'zencart');
    // sorry zencart - didn't had the time to migrate everything to your DB-Class (might come later - its cool)
    // http://www.zen-cart.com/wiki/index.php/Developers_-_Porting_modules_from_osC
    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/osc_database.php');

    // e.g. '1' . '5.5'
    mh_define('MH_PLATFORM_ZENCART', mh_cfg('PROJECT_VERSION_MAJOR') . '.' . str_replace('.', '', mh_cfg('PROJECT_VERSION_MINOR')));
    mh_define('MH_SITEZEN_PLATFORM', 'zencart');
    mh_define('MH_SITEZEN_PLATFORM_VERSION', mh_cfg('MH_PLATFORM_ZENCART'));


} elseif (function_exists('gm_get_conf')) {
    mh_define('MH_PLATFORM', 'gambio');
    if (!function_exists('xtc_date_short')) {
        require_once(DIR_FS_INC . 'xtc_date_short.inc.php');
    }
    if (!function_exists('xtc_parse_input_field_data')) {
        require_once(DIR_FS_INC . 'xtc_parse_input_field_data.inc.php');
    }
    if (!function_exists('xtc_get_products_name')) {
        require_once(DIR_FS_INC . 'xtc_get_products_name.inc.php');
    }
    $gx_version = 0;
    include(MH_DIR_FS_CATALOG . 'release_info.php');
    // $gx_version = 'v2.1.5.0'
    // $gx_version = '2.2_develop';
    preg_match('/(?:\d*\.)?\d+/', $gx_version, $version_matches);
    mh_define('MH_PLATFORM_GAMBIO', $version_matches[0]);
    mh_define('MH_PLATFORM_GAMBIO_GX_VERSION', str_replace('v', '', $gx_version));

    mh_define('MH_SITEZEN_PLATFORM', 'gambio');
    mh_define('MH_SITEZEN_PLATFORM_VERSION', mh_cfg('MH_PLATFORM_GAMBIO_GX_VERSION'));

//    if (class_exists(LegacyDependencyContainer::class)) {
    if (version_compare(MH_PLATFORM_GAMBIO_GX_VERSION, '4.1.1.0', '>=')) {
        // die Container-Klasse ist ab 4.1.1.0 verfuegbar, also alles innerhalb des if-branches ist fuer > 4.1.1.0
        mh_define('MH_PLATFORM_GAMBIO_GX_CONFIGURATION', true);
    } else {
        // Shop Version < 4.1.1.0
    }

} elseif (defined('PROJECT_VERSION_PLAIN')) {
    mh_define('MH_PLATFORM', 'mercari');
    if (!function_exists('date_short')) {
        require_once(DIR_FS_INC . 'inc.date_short.php');
    }

    if (!function_exists('parse_input_field_data')) {
        require_once(DIR_FS_INC . 'inc.parse_input_field_data.php');
    }
    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/osc_database.php');
    $db_link = tep_db_connect();
    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/oscommerce/split_page_results.php');
    mh_define('MH_PLATFORM_MERCARI', mh_cfg('PROJECT_VERSION_TYPE') . ' ' . mh_cfg('PROJECT_VERSION_PLAIN'));

    if (is_object($message_stack)) {
        $messageStack = $message_stack;
    }

} elseif (function_exists('xtc_redirect')) {
    mh_define('MH_PLATFORM', 'xtc');
    if (!function_exists('xtc_date_short')) {
        require_once(DIR_FS_INC . 'xtc_date_short.inc.php');
    }
    if (!function_exists('xtc_parse_input_field_data')) {
        if (file_exists(DIR_FS_INC . 'xtc_parse_input_field_data.inc.php')) {
            require_once(DIR_FS_INC . 'xtc_parse_input_field_data.inc.php');
        } else {
            // cseov2next ultimate
            function xtc_parse_input_field_data($data, $parse)
            {
                return strtr(trim($data), $parse);
            }
        }
    }

    // matches xtcModfied and modified
    mh_define('MH_PLATFORM_XTCM', preg_match('/odified/', PROJECT_VERSION));
    mh_define('MH_SITEZEN_PLATFORM', 'modified-shop');

    if (file_exists(DIR_FS_CATALOG . DIR_ADMIN . 'includes/version.php')) {
        require_once(DIR_FS_CATALOG . DIR_ADMIN . 'includes/version.php');
        mh_define('MH_SITEZEN_PLATFORM_VERSION', defined('PROJECT_VERSION_NO') ? PROJECT_VERSION_NO : false);
//        mh_define('MH_PLATFORM_RELEASE_DATE', PROJECT_RELEASE_DATE);
    }




    if (MH_PLATFORM_XTCM) {
        if (
            stristr(PROJECT_VERSION, 'modified eCommerce Shopsoftware v2.0.6') ||
            stristr(PROJECT_VERSION, 'modified eCommerce Shopsoftware v2.0.7')

        ) {
            mh_define('MH_PLATFORM_XTC_XTCM_VERSION', 2);
            // mh_define('NEW_ADMIN_STYLE', true); // 	Constant NEW_ADMIN_STYLE already defined in File: /admin/includes/head.php on Line: 20

            //mh_define('NEW_ADMIN_STYLE', true);
        } elseif (stristr(PROJECT_VERSION, 'modified eCommerce Shopssoftware v2')) {
            mh_define('MH_PLATFORM_XTC_XTCM_VERSION', 2);
            mh_define('NEW_ADMIN_STYLE', true);
        } elseif (stristr(PROJECT_VERSION, 'modified eCommerce Shopsoftware v3')) {
            mh_define('MH_PLATFORM_XTC_XTCM_VERSION', 2);
            mh_define('NEW_ADMIN_STYLE', true);
        } else {
            mh_define('MH_PLATFORM_XTC_XTCM_VERSION', false);
        }
        mh_define('MH_SITEZEN_PLATFORM_VERSION', MH_PLATFORM_XTC_XTCM_VERSION);
    }


    mh_define('MH_PLATFORM_XTC_SEO', preg_match('/commerce:SEO/', PROJECT_VERSION));
    mh_define('MH_PLATFORM_XTC_ECB', preg_match('/eComBASE/', PROJECT_VERSION));

    if (defined('MH_PLATFORM_XTC_SEO')) {

        // get version
        if (stristr(PROJECT_VERSION, 'v2.1')) {
            mh_define('MH_PLATFORM_XTC_SEO_VERSION', '2.1');
        }
    }


} elseif (defined('FILENAME_ADVANCED_MENU')) {
    mh_define('MH_PLATFORM', 'digistore');
} elseif (preg_match('/CRE Loaded/', PROJECT_VERSION) || preg_match('/Loaded/', PROJECT_VERSION)) {
    // CRE Loaded PCI B2B
    mh_define('MH_PLATFORM', 'creloaded');

    if (preg_match('/CRE Loaded PCI B2B/', PROJECT_VERSION) || preg_match('/Loaded Commerce B2B/', PROJECT_VERSION)) {
        mh_define('MH_PLATFORM_CRE', 'B2B');
    } else {
        mh_define('MH_PLATFORM_CRE', '');
    }

} else {
    mh_define('MH_PLATFORM', 'oscommerce');
    if (function_exists('tep_get_version')) {
        mh_define('MH_PLATFORM_OSC', (float)tep_get_version());
    } else {
        mh_define('MH_PLATFORM_OSC', '2.2');
    }

    if (MH_PLATFORM_OSC > 2.2) {
        mh_define('MH_PLATFORM_OSC_23', true);
    }

    mh_define('MH_PLATFORM_OSC_PHOENIX', preg_match('/Phoenix/', PROJECT_VERSION));
    if (MH_PLATFORM_OSC_PHOENIX) {
        mh_define('MH_PLATFORM_OSC_23', true); // Pheonix derived from oscommerce 2.3 but has Version 1
    }

    mh_define('MH_PLATFORM_OSCMAX_25', preg_match('/osCmax v2.5/', PROJECT_VERSION));

    mh_define('MH_PLATFORM_TRUELOADED', preg_match('/Trueloaded/', PROJECT_VERSION));

    // WP Online Store
    if (defined('WPOLS_PLUGINS_DIR')) {
        mh_define('MH_PLATFORM_OSC_WPOS', PROJECT_VERSION);
        mh_define('MH_FORM_METHOD', 'post');
        mh_define('MH_PAGE_NAME', 'pages');

        $post = mh_cfg('MAILBEEZ_MAILHIVE_WPOLS_PAGE_ID');
        if (mh_cfg('MH_CONTEXT') == 'STORE') {
            $GLOBALS['post'] = &get_post($post);
        } else {
            if (strtolower($_SERVER["REQUEST_METHOD"]) == 'post') {
                $_GET = $_REQUEST;
            }
        }
    }
}

// Fallback osCommerce, Gambio
mh_define('FILENAME_PRODUCT', 'categories.php');


mh_define('MH_PLATFORM_OSC', false);
mh_define('MH_PLATFORM_OSC_23', false);
mh_define('MH_PLATFORM_OSCMAX_25', false);
mh_define('MH_PLATFORM_OSC_PHOENIX', false);
mh_define('MH_PLATFORM_TRUELOADED', false);
mh_define('MH_PLATFORM_GAMBIO', false);
mh_define('MH_PLATFORM_GAMBIO_GX_CONFIGURATION', false);
mh_define('MH_PLATFORM_GAMBIO_GX_VERSION', false);
mh_define('MH_PLATFORM_ZENCART', false);
mh_define('MH_PLATFORM_XTCM', false);
mh_define('MH_PLATFORM_XTC_SEO', false);
mh_define('MH_PLATFORM_XTC_ECB', false);
mh_define('MH_PLATFORM_XTC_XTCM_VERSION', false);
mh_define('MH_SITEZEN_PLATFORM', false);
mh_define('MH_SITEZEN_PLATFORM_VERSION', false);
