<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

  v2.7.2

  update functions
 */

///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////


if (!function_exists('mh_get_field_info')) {
    function mh_get_field_info($table, $column)
    {
        $res = mh_db_query("SHOW FULL COLUMNS FROM `" . addslashes($table) . "` LIKE '" . addslashes($column) . "'");
        if ($row = mh_db_fetch_array($res)) {
            return [
                'Type' => strtolower($row['Type']),
                'Collation' => $row['Collation'],
                'Null' => $row['Null'],
                'Key' => $row['Key'],
                'Default' => $row['Default'],
                'Extra' => $row['Extra'],
                'Comment' => $row['Comment'],
                'Field' => $row['Field'],
                'Privileges' => $row['Privileges']

            ];
        }
        return null;
    }
}

function mh_db_check_index_on_column_exists($table, $index_column)
{
    $query_raw = "SHOW INDEX FROM " . $table . "";
    $query = mh_db_query($query_raw);
    while ($item = mh_db_fetch_array($query)) {
        if ($item['Key_name'] == $index_column) {
            return $item;
        }
    }
    // not found
    return false;
}


function mh_db_check_field_exists($table, $field)
{
    $found_columns = array();
    $query_raw = "SHOW COLUMNS FROM " . $table . "";
    $query = mh_db_query($query_raw);
    while ($item = mh_db_fetch_array($query)) {

        if (is_array($field)) {
            foreach ($field as $col) {
                if ($item['Field'] == $col) {
                    $found_columns[] = $col;
                }
            }
        } else {
            if ($item['Field'] == $field) {
                return $item;
            }
        }
    }
    if (is_array($field)) {
        return $found_columns;
    }
    // not found
    return false;
}


function mh_db_check_table_exists($table)
{
    $query_raw = "SHOW TABLES LIKE '" . $table . "'";
    $query = mh_db_query($query_raw);
    $result = mh_db_num_rows($query);
    return ($result > 0);
}


function mh_db_add_field($table, $field, $sql)
{
    // check if exists
    $result = mh_db_check_field_exists($table, $field);
    if ($result === false) {
        if (is_array($sql)) {
            foreach ($sql as $i => $sql_item) {
                mh_db_query($sql_item);
            }
        } else {
            mh_db_query($sql);
        }
    }
}

function mh_db_change_field($table, $field, $type, $sql)
{
    // check if exists
    $result_item = mh_db_check_field_exists($table, $field);

    if ($result_item['Type'] != $type) {
        if (is_array($sql)) {
            foreach ($sql as $i => $sql_item) {
                mh_db_query($sql_item);
            }
        } else {
            mh_db_query($sql);
        }
    }
}
