<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2013 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

  v2.2

  version check functions
 */

///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////


function mh_update_reminder_timestamp()
{
    // update reminder timestamp
    if (is_null(mh_cfg('MAILBEEZ_MAILHIVE_UPDATE_REMINDER_TIMESTAMP'))) {
        $wait_first_time = 60;
        mh_insert_config_value(array('configuration_title' => 'Update Reminder Timestamp',
            'configuration_key' => 'MAILBEEZ_MAILHIVE_UPDATE_REMINDER_TIMESTAMP',
            'configuration_value' => time() + $wait_first_time,
            'configuration_description' => 'This is automatically updated. No need to edit.',
            'set_function' => ''
        ));
        mh_define('MAILBEEZ_MAILHIVE_UPDATE_REMINDER_TIMESTAMP', time() + $wait_first_time);
    } elseif (mh_cfg('MAILBEEZ_MAILHIVE_UPDATE_REMINDER_TIMESTAMP') < time()) {
        mh_update_config_value(array(
            'configuration_key' => 'MAILBEEZ_MAILHIVE_UPDATE_REMINDER_TIMESTAMP',
            'configuration_value' => (time() + (7 * 24 * 60 * 60))
        ));
    }
}

function mh_update_check_timestamp()
{
        if (is_null(mh_cfg('MAILBEEZ_MAILHIVE_UPDATE_CHECK_TIMESTAMP'))) {
        mh_insert_config_value(array('configuration_title' => 'Update Check Timestamp',
            'configuration_key' => 'MAILBEEZ_MAILHIVE_UPDATE_CHECK_TIMESTAMP',
            'configuration_value' => time(),
            'configuration_description' => 'This is automatically updated. No need to edit.',
            'set_function' => ''
        ));
    } else {
        mh_update_config_value(array(
            'configuration_key' => 'MAILBEEZ_MAILHIVE_UPDATE_CHECK_TIMESTAMP',
            'configuration_value' => (time() + (7 * 24 * 60 * 60))
        ));
    }
}

function mh_version_check_inline()
{
    // gambiocloud
    if (mh_cfg('is_cloud')) {
        return false;
    }
    mh_version_check_core();

    $module_class_array = array('ce');

    $check_result_content_json = mh_versioncheck_getCurlContent(mh_cfg('MAILBEEZ_VERSION_CHECK_URL'));
    $check_result_content = json_decode($check_result_content_json, true);
//print_r($check_result_content); exit();
    $_SESSION['mailbeez_upd_cnt_sum'] = 0;
    $_SESSION['mailbeez_new_cnt_sum'] = 0;
    foreach ($module_class_array as $module_class) {

        if (sizeof($check_result_content[$module_class]) > 0) {
            foreach ($check_result_content[$module_class] as $beez_type => $module_type_array) {
                $_SESSION['mailbeez_upd_cnt'][$beez_type] = 0;
                $_SESSION['mailbeez_new_cnt'][$beez_type] = 0;
                if (sizeof($module_type_array) > 0) {
                    foreach ($module_type_array as $module_code => $module_info_array) {
                        $installed_version = false;
                        switch ($beez_type) {
                            case 'mailbeez':
                                require_once(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'common/classes/mailbeez.php');
                                $b = new mailbeez();
                                $installed_version = $b->get_installed_version($module_code);
                                break;
                            case 'filterbeez':
                                require_once(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'common/classes/filterbeez.php');
                                $b = new filterbeez();
                                $installed_version = $b->get_installed_version($module_code);
                                break;
                            case 'reportbeez':
                                require_once(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'common/classes/reportbeez.php');
                                $b = new reportbeez();
                                $installed_version = $b->get_installed_version($module_code);
                                break;
                            case 'configbeez':
                                require_once(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'common/classes/configbeez.php');
                                $b = new configbeez();
                                $installed_version = $b->get_installed_version($module_code);
                                break;
                            case 'dashboardbeez':
                                require_once(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'common/classes/dashboardbeez.php');
                                $b = new dashboardbeez();
                                $installed_version = $b->get_installed_version($module_code);
                                break;

                        }
                        $module_info_array['title'] = $module_code;
                        $module_info_array['price'];
                        $module_info_array['teaser'];
                        $module_info_array['image'];

                        // check against the installed version
//                if (true) {
                        if ($installed_version > 1 && $module_info_array['version'] > $installed_version) {
                            // new version
                            $_SESSION['mailbeez_upd_cnt'][$beez_type]++;
                            $_SESSION['mailbeez_upd_cnt_sum']++;
                            $_SESSION['mailbeez_upd'][$module_code] = $module_info_array['version'];
                        } else {
                            // not installed
                            //check if module exists
                            if (file_exists(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . $beez_type . '/' . $module_code . '.php')) {
                                $_SESSION['mailbeez_new_cnt'][$beez_type]++;
                                $_SESSION['mailbeez_new_cnt_sum']++;
                                $_SESSION['mailbeez_new'][$beez_type][$module_code] = $module_info_array;
                            }

                        }
                    }
                }
            }
        }
        $_SESSION['mailbeez_upd_msg'] = $check_result_content['notification'];
    }

    mh_update_check_timestamp();
}

function mh_version_check_core()
{

    if (mh_cfg('is_cloud')) {
        // re-enable update check on gambio cloud
//        return false;
    }

    // timed caching
    if (isset($_SESSION['mh_version_core_check']) && (time() - $_SESSION['mh_version_core_check_timestamp'] < 300)) {
        return $_SESSION['mh_version_core_check'];
    }

    $check_result_content_json = mh_versioncheck_getCurlContent(mh_cfg('MAILBEEZ_VERSION_CHECK_URL'));

    $check_result_content = json_decode($check_result_content_json, true);

    if (mh_cfg('MAILBEEZ_VERSION') < $check_result_content['core']['version']) {
        $_SESSION['mh_version_core_check'] = $check_result_content['core']['version'];
    }
    $_SESSION['mh_version_core_check_timestamp'] = time();
}

function mh_version_core_check_refresh()
{
    unset($_SESSION['mh_version_core_check']);
    unset($_SESSION['mh_version_core_check_notification']);
}

function mh_version_check_clear()
{
    unset($_SESSION['mailbeez_upd_cnt']);
    unset($_SESSION['mailbeez_new_cnt']);
    unset($_SESSION['mailbeez_upd_cnt_sum']);
    unset($_SESSION['mailbeez_new_cnt_sum']);
    unset($_SESSION['mailbeez_upd']);
    unset($_SESSION['mailbeez_new']);
    unset($_SESSION['mailbeez_upd_msg']);
}

function mh_versioncheck_getCurlContent($url)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url . '|' . $_SERVER['SERVER_NAME']);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
    //curl_setopt($ch, CURLOPT_USERAGENT, $this->user_agent);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    $content = curl_exec($ch);

    if (empty($content)) {
        print curl_error($ch);
    } else {
        $info = curl_getinfo($ch);
        //print_r($info);
    }
//    echo $url;
    curl_close($ch);
    return $content;
}


function mh_check_module_versions()
{

    $release_module_compatibility = array();
    require_once(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'common/version/module_compatibility.php');

    $output = '';
    foreach ($release_module_compatibility as $beez_type => $module_type_array) {

        $installed_version = false;
        foreach ($module_type_array as $module_code => $module_info_array) {
            switch ($beez_type) {
                case 'mailbeez':
                    require_once(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'common/classes/mailbeez.php');
                    $b = new mailbeez();
                    $installed_version = $b->get_installed_version($module_code);
                    break;
                case 'filterbeez':
                    require_once(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'common/classes/filterbeez.php');
                    $b = new filterbeez();
                    $installed_version = $b->get_installed_version($module_code);
                    break;
                case 'reportbeez':
                    require_once(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'common/classes/reportbeez.php');
                    $b = new reportbeez();
                    $installed_version = $b->get_installed_version($module_code);
                    break;
                case 'configbeez':
                    require_once(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'common/classes/configbeez.php');
                    $b = new configbeez();
                    $installed_version = $b->get_installed_version($module_code);
                    break;
                case 'dashboardbeez':
                    require_once(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'common/classes/dashboardbeez.php');
                    $b = new dashboardbeez();
                    $installed_version = $b->get_installed_version($module_code);
                    break;

            }
            // check against the installed version
            if ($installed_version > 1 && $module_info_array['version'] > $installed_version) {
                // load module
                // load language file
                // output module title, link, download info -> avangate

                if (!is_object($GLOBALS[$module_code])) {
                    include_once(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . '' . $beez_type . '/' . $module_code . mh_cfg('MH_FILE_EXTENSION'));
                    if (class_exists($module_code)) {
                        $module_directory_current = mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . '' . $beez_type . '/';
                        $module_path = mh_get_class_path($module_code);
                        mh_load_modules_language_files($module_directory_current, $module_path, mh_cfg('MH_FILE_EXTENSION'));
                        $GLOBALS[$module_code] = new $module_code;
                    }
                }

                if ($GLOBALS[$module_code]->title) {
                    $output .= '<li><a href="' . mh_language_documentation_url($GLOBALS[$module_code]->documentation_root . $GLOBALS[$module_code]->documentation_key) . '" target="_blank">' . $GLOBALS[$module_code]->title . ' (' . $installed_version . ')</a></li>';
                }
            }
        }
    }
    if ($output != '') {
        $output = '<ul>' . $output . '</ul>';
    }

    return $output;
}

