<?php

use Gambio\Admin\Layout\Menu\Events\CoreMenuDataCollected;
use Gambio\Admin\Layout\Menu\Factories\CacheMenuFactory as MenuFactory;
use Gambio\Admin\Layout\Menu\Filter\Condition;
use Gambio\Admin\Layout\Menu\Filter\Conditions;
use Gambio\Admin\Layout\Menu\Filter\Types\ConfigActive;
use Gambio\Core\Application\Application;

class MailbeezMenuListener
{
    private const MAILBEEZ_MENU_GROUP = [
        'id' => 'mailbeez_id',
        'title' => 'Mailbeez',
        'class' => 'fa fa-envelope',
        'sort' => 75,
    ];

    private const MAILBEEZ_MENU_ITEMS = [
        [
            'title' => 'admin_menu.BOX_MAILBEEZ',
            'link' => 'mailbeez.php',
            'sort' => 1,
        ],
        [
            'title' => 'admin_menu.BOX_MAILBEEZ_SHOPVOTING',
            'link' => 'mailbeez.php',
            'link_param' => 'module=config_shopvoting',
            'sort' => 2,
        ]
    ];

    private $menuFactory;


    public function __construct(MenuFactory $menuFactory)
    {
        $this->menuFactory = $menuFactory;
    }


    public static function register(Application $application): void
    {
        // die share methode wird bentigt, damit die application wei, wie der listener zusammengebaut wird
        // (erst wenn das event dispatched wird, wird der listener mittels __construct erzeugt).

        // GX4.5 compatiblity
        if (method_exists($application, 'registerShared')) {
            $application->registerShared(__CLASS__)->addArgument(MenuFactory::class);
        }

        if (method_exists($application, 'share')) {
            $application->share(__CLASS__)->addArgument(MenuFactory::class);
        }
    }


    public function __invoke(CoreMenuDataCollected $event): CoreMenuDataCollected
    {
        // die invoke methode wird vom dispatcher aufgerufen, sobald ein event verarbeitet wird. In den Fall ist es
        // das Gambio\Admin\Layout\Menu\Events\CoreMenuDataCollected. Da der dispatcher PSR-14 folgt, muss am ende
        // das event wieder zurck gegeben werden, um von weiteren listener verarbeitet zu werden
        // https://www.php-fig.org/psr/psr-14/

        // Condition filtert meneintrge. in dem fall wird der eintrag nur angezeigt, wenn die config
        // MODULE_CENTER_MAILBEEZ_INSTALLED aktiv ist
        $condition = Condition::create(ConfigActive::FILTER_METHOD, ['MODULE_CENTER_MAILBEEZ_INSTALLED']);
        $conditions = new \Gambio\Admin\Layout\Menu\Filter\Conditions($condition);

        // zuerst erstellen wir den haupteintrag
        $mailbeezMenuGroup = $this->menuFactory->createMenuGroup(self::MAILBEEZ_MENU_GROUP, $conditions);

        // nachdem er erstellt worden ist knnen die einzelnen items hinzugefgt werden
        foreach (self::MAILBEEZ_MENU_ITEMS as $item) {
            $mailbeezMenuGroup->add(
                $this->menuFactory->createMenuItem($item)
            );
        }

        // letztendlich wird die neue gruppe mit hilfe des $event objects zum menuhinzugefgt
        $event->addGroup($mailbeezMenuGroup);

        return $event;
    }
}
