<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011, 2012 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');

mh_define('MAILBEEZ_ANALYTICS_STATUS_ICON', '<svg xmlns="http://www.w3.org/2000/svg" class="h-full w-auto" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 16v5"/><path d="M16 14v7"/><path d="M20 10v11"/><path d="m22 3-8.646 8.646a.5.5 0 0 1-.708 0L9.354 8.354a.5.5 0 0 0-.707 0L2 15"/><path d="M4 18v3"/><path d="M8 14v7"/></svg>');


class config_analytics extends configbeez
{
// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_analytics';
        $this->module = 'config_analytics'; // same as folder name
        $this->version = '2.0'; // float value
        $this->title = mh_lng('MAILBEEZ_CONFIG_ANALYTICS_TEXT_TITLE');
        $this->label = mh_lng('MAILBEEZ_CONFIG_ANALYTICS_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_CONFIG_ANALYTICS_TEXT_DESCRIPTION');
        $this->description_image = '../../common/images/icon_ma_64.png';
        $this->icon = '../../common/images/icon_ma.png';
        $this->removable = false; // can't be removed
        $this->stealth = true; // don't list as an installed module
        $this->display_as_submodule_of = 'config';
        $this->sort_order = 4;
        $this->enabled = mh_cfg('MAILBEEZ_MAILHIVE_STATUS') == 'True';
        $this->on_cfg_save_clear_template_c = true;
        $this->beez_ui_ready = true;
        $this->group = self::GROUP_ANALYTICS;


        if (mh_cfg('MAILBEEZ_ANALYTICS_STATUS') == 'False') {
            $this->admin_action_plugins = 'confirm.php';
            $this->admin_action_plugins_path = MH_DIR_CONFIG;
            $this->is_configurable = false;
        }


        $this->documentation_key = 'config_analytics'; // leave empty if no documentation available

        $this->_blueprint();

    }



// class methods

    function getAudience()
    {
        return false;
    }

    function check()
    {
        return true;
    }

    function remove()
    {
        return false;
    }

    // installation methods

    function keys()
    {
        if (mh_cfg('MAILBEEZ_ANALYTICS_STATUS') == 'True') {
            $keys_array = array('MAILBEEZ_ANALYTICS_STATUS', 'MAILBEEZ_ANALYTICS_SUBTOTAL_MODULE', 'MAILBEEZ_ANALYTICS_OPEN_RATES_AUTO', 'MAILBEEZ_ANALYTICS_DO_RUN', 'MAILBEEZ_ANALYTICS_AUTOINSERT_PIX', 'MAILBEEZ_ANALYTICS_REWRITE_FORMAT', 'MAILBEEZ_ANALYTICS_SPLITPAGE_NUM', 'MAILBEEZ_ANALYTICS_BEGIN_OF_TIME');
        }
        return $keys_array;
    }

    function install()
    {
        return false;
    }

    function list_modules($params)
    {

        $ot_modules_installed = explode(';', mh_cfg('MODULE_ORDER_TOTAL_INSTALLED'));
        $ot_modules_array = array();
        foreach ($ot_modules_installed as $ot_mod) {
            $ot_mod = str_replace('.php', '', $ot_mod);
            $ot_modules_array[] = array('id' => $ot_mod, 'text' => $ot_mod);
        }

        $ot_module = $params[0];
        $key = $params[1];

        $name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
        return mh_draw_pull_down_menu($name, $ot_modules_array, $ot_module);
    }
}
