<?php
/*
 MailBeez Automatic Trigger Email Campaigns
 http://www.mailbeez.com

 Copyright (c) 2010 - 2012 MailBeez

 inspired and in parts based on
 Copyright (c) 2003 osCommerce

 Released under the GNU General Public License

 v2.6
*/

mh_define('MH_POPUP', true);

mh_load_modules_language_files(MH_DIR_CONFIG, 'config_api', MH_FILE_EXTENSION);

class mailbeez_test_client {
    private $host = MAILBEEZ_API_ENTRYPOINT;
    private $api_key = MAILBEEZ_API_KEY;
    private $ssl = MAILBEEZ_API_SSL;
    private $port = MAILBEEZ_API_PORT;



    public function __construct()
    {
    }

    public function showDocs($params)
    {
        $params['apikey'] = $this->api_key;

        return $this->handleRequest('private/v1.0/doc', $params);
    }


    public function handleRequest($url, $params)
    {
        $json = $this->http_request_curl('GET', $this->host, $this->port, $url, $params, array());
        $json = json_decode($json, true);

        //return it to caller:
        return $json;
    }

    private function http_request_curl($method, $host, $port, $path, $get, $post)
    {
        // Initialize session.
        $ch = curl_init();
        $prefix = ($this->ssl) ? "https://" : "http://";

        // Set so curl_exec returns the result instead of outputting it.
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $get_params = '';
        if ($method == 'POST') {
            // POST
            $post_data_str = '';
            foreach ($post as $k => $v) {
                $post_data_str .= urlencode($k) . '=' . urlencode($v) . '&';
            }
            $post_data_str = substr($post_data_str, 0, -1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data_str);
        } else {
            // GET
            $get_data_str = '';
            foreach ($get as $k => $v) {
                $get_data_str .= urlencode($k) . '=' . urlencode($v) . '&';
            }
            $get_data_str = substr($get_data_str, 0, -1);
            $get_params = '?' . $get_data_str;
        }
        // echo $prefix . $host . $path . $get_params;

        curl_setopt($ch, CURLOPT_URL, $prefix . $host . $path . $get_params);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        //curl_setopt($ch, CURLOPT_VERBOSE, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($ch, CURLOPT_FRESH_CONNECT, 1);

        $version = curl_version();
        if (isset($version['features']) && defined('CURLOPT_IPRESOLVE')) {
            // http://stackoverflow.com/questions/11004624/failed-to-connect-to-2a032880101f03faceb00c026-network-is-unreachable-fr
            curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        }

        $json = curl_exec($ch);
        if (empty($json)) {
            //echo $path;
            //print curl_error($ch);
            // die('curl error');
        } else {
            $info = curl_getinfo($ch);
            // print_r($info);
            // die('curl info');
        }


        $info = curl_getinfo($ch);
        //print_r($info);


        // Get the response and close the channel.
        curl_close($ch);
        return $json;
    }

}


$apiObj = new mailbeez_test_client();
$result = $apiObj->showDocs(null);


?>
<div style="text-align: left; font-size: 16px !important;">
    Installed API
    <hr>
    Entrypoint:
    <br>
    <?php echo mh_lng('MAILBEEZ_API_ENTRYPOINT'); ?>

    <pre style="font-size: 16px !important;">
    <?php
echo $result['result'];
    ?>
    </pre>
</div>
