<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2014 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  
  V2.9.7
 */

///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');
require_once(MH_DIR_CONFIG . 'config_cloudbeez/classes/api_cloudbeez_consumer.php');
require_once(MH_DIR_CONFIG . 'config_cloudbeez/classes/api_cloudbeez_public.php');
require_once(MH_DIR_CONFIG . 'config_cloudbeez/classes/cloudbeez_status_handler.php');

class config_cloudbeez extends configbeez
{

// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_cloudbeez';
        $this->module = 'config_cloudbeez'; // same as folder name
        $this->version = '1.2'; // float value
        $this->title = mh_lng('MAILBEEZ_CONFIG_CLOUDBEEZ_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_CONFIG_CLOUDBEEZ_TEXT_DESCRIPTION');
        $this->description_image = '../../common/images/icon_system_64.png';
        $this->icon = '../../common/images/icon_system.png';
        $this->removable = false; // can't be removed
        $this->stealth = false; // don't list as an installed module
        $this->display_as_submodule_of = 'config';
        $this->sort_order = 0;
        $this->enabled = true;
        $this->status_key = 'MAILBEEZ_CONFIG_CLOUDBEEZ_STATUS';
        $this->admin_action_plugins_path = mh_cfg('MH_DIR_CONFIG'); // default-path to include admin action plugins from
        $this->admin_action_plugins = 'cloudbeez_register.php;cloudbeez_refresh.php';
        $this->documentation_key = 'config_cloudbeez'; // leave empty if no documentation available


        /*
        list($show_select_package, $show_waiting_info, $show_install_package, $show_update_package) = cloudbeez_status_handler::getStatus();
        $a = cloudbeez_status_handler::getStatus();
        print_r($a);

        $cloud_api = new cloudBeezApiConsumer(CLOUDLOADER_API_KEY);
        $is_installed = $cloud_api->checkIsInstalled();
    */

        /*

        // only install when available for this store
        // check if subscriptions are allowed
        $cloud_public_api = new cloudBeezPublicApiConsumer();

        $status_result = $cloud_public_api->getApiStatus();
        if ($status_result['result']) {
            $result = $cloud_public_api->getProPermission();
            $show_module = $result['result'];

            // clear caches
            unset($_SESSION['cache_cloudbeez_status_handler_time']);
            unset($_SESSION['cache_cloudbeez_status_handler']);
            unset($_SESSION['subscription_check_result']);
            unset($_SESSION['subscription_check_result_subscription_info']);
        } else {
            // no api connection - server down?
            $show_module = false;
        }

        */

        $show_module = true;
        $this->hidden = !$show_module;

        // self installing
        if (!mh_cfg($this->status_key) || !mh_cfg('CLOUDLOADER_API_KEY')) {
            $this->install();
        } else {
            $this->check_update();
        }
    }

    function config_cloudbeez()
    {
        self::__construct();
    }

// class methods

    function getAudience()
    {
        return false;
    }

    function check()
    {
        return true;
    }

    function remove()
    {
        return false;
    }

    // installation methods

    function keys()
    {
        // $keys_array = array('MAILBEEZ_CONFIG_CLOUDBEEZ_STATUS', 'CLOUDLOADER_API_KEY');
        $keys_array = array('CLOUDLOADER_API_KEY');
        return $keys_array;
    }

    function onSave()
    {
        unset($_SESSION['cache_cloudbeez_status_handler_time']);
        unset($_SESSION['cache_cloudbeez_status_handler']);

        mh_storage_destroy('subscription_check_result');
        mh_storage_destroy('subscription_check_result_subscription_info');

        $cloudbeez_connection_cache = new cloudbeez_status_cache();
        $cloudbeez_connection_cache->set_cache_id('cloudbeez', 'cloudbeez');
        $cloudbeez_connection_cache->purge_cache('app');
    }

    function install()
    {

        mh_insert_config_value(array('configuration_title' => 'CloudLoader API Key',
            'configuration_key' => 'CLOUDLOADER_API_KEY',
            'configuration_value' => '',
            'configuration_description' => 'Your API Key for www.cloudbeez.com',
        ));

        mh_insert_config_value(array('configuration_title' => 'CloudLoader Private API Key',
            'configuration_key' => 'CLOUDLOADER_PRIVATE_API_KEY',
            'configuration_value' => md5(time()),
            'configuration_description' => 'local API key',
        ));

        mh_insert_config_value(array('configuration_title' => 'Activate',
            'configuration_key' => 'MAILBEEZ_CONFIG_CLOUDBEEZ_STATUS',
            'configuration_value' => 'True',
            'configuration_description' => 'no need to edit'
        ));
    }

    function update($installed_version = null)
    {
        mh_insert_config_value(array('configuration_title' => 'CloudLoader Private API Key',
            'configuration_key' => 'CLOUDLOADER_PRIVATE_API_KEY',
            'configuration_value' => md5(time()),
            'configuration_description' => 'local API key',
        ), true);
        parent::update($this->version);
    }

}

