<?php

/*
 * tested:
 * xtc-m 1.05
 * osc2.2
 * osc2.33
 * gambiogx2 pro
 * zencart 1.5
 *
 *
 *
 *
 *
 */

//

// fastest loading mode
mh_define('MH_SLIM_MODE', true);

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/compatibility.php');
require_once(MH_DIR_CONFIG . 'config_customer_insight.php');
require_once(MH_DIR_CONFIG . 'config_customer_insight/functions/general.php');
require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/viewbeez.php');
$updatecheck = new config_customer_insight();

class mailbeez_admin_hooks extends viewbeez
{



    function __construct($page)
    {
        $this->platform = MH_PLATFORM;
        $this->page = $page;
        $this->hooks_template_dir = MH_DIR_CONFIG . 'config_customer_insight/includes/hooks/';
        $this->headers_template_dir = MH_DIR_CONFIG . 'config_customer_insight/includes/headers/';
        $this->headers_config_dir = MH_DIR_CONFIG . 'config_customer_insight/languages/';

        $this->smarty = new mh_Smarty;
        $this->smarty->setCaching(false);
        $this->smarty->setCompileId($this->page);

        $this->smarty->setCompileCheck(true);

        $this->smarty->left_delimiter = '[[';
        $this->smarty->right_delimiter = ']]';

        $this->smarty->setConfigDir($this->headers_config_dir);


        $this->content_view_url = mh_href_link(FILENAME_MAILBEEZ, 'app=load_app&app_path=config_customer_insight/admin_application_plugins/context_view.php&popup=true');
        $this->helpdesk_inline_url = mh_href_link(FILENAME_MAILBEEZ, 'app=load_app&app_path=config_beezdesk/admin_application_plugins/helpdesk_inline.php&popup=true');

        $this->load_hook_php();
        $this->smarty->assign(array('order_id' => $this->order_id));
        $this->smarty->assign(array('customersID' => $this->customer_id));

        parent::__construct();

        // load all customer insight view modules
        $mailbeez_insight_all_modules = mh_insight_view(null, false, 'panel');

        if ($page == 'PANEL') {
            $panel_cnt_open = isset($GLOBALS['view_conversations']) ? $GLOBALS['view_conversations']->cnt_open() : 0;
            $panel_cnt_notification = 0;
            if (isset($GLOBALS['view_notifications']) && is_object($GLOBALS['view_notifications'])) {
                $panel_cnt_notification = $GLOBALS['view_notifications']->cnt_notifications();
            }
            $this->smarty->assign('panel_notification_cnt', $panel_cnt_open + $panel_cnt_notification);
        }
        $cnt_open = isset($GLOBALS['view_conversations']) ?  $GLOBALS['view_conversations']->cnt_open($this->customer->id) : 0;
        $this->smarty->assign('open_msg_cnt', $cnt_open);
        if (isset($GLOBALS['view_notifications']) && is_object($GLOBALS['view_notifications'])) {
            $cnt_notification = $GLOBALS['view_notifications']->cnt_notifications($this->customer->id);
            $this->smarty->assign('notifications_cnt', $cnt_notification);
        }


        $this->smarty->assign(array('MH_CATALOG_URL' => MH_CATALOG_SERVER . MH_DIR_WS_CATALOG,
            'MH_ROOT_PATH' => MH_ROOT_PATH,
            'CONTEXT_VIEW_URL' => $this->content_view_url,
            'HELPDESK_INLINE_URL' => $this->helpdesk_inline_url));


//        $this->smarty->assign('order_id', $this->order_id);

        // lngrefactor

        if (file_exists($this->headers_config_dir . $_SESSION['language'] . '.conf')) {
            $this->smarty->assign('language', $_SESSION['language']);
        } else {
            $this->smarty->assign('language', 'english');
        }
    }

    function mailbeez_admin_hooks($page)
    {
        self::__construct($page);
    }

    function header_output()
    {
        return $this->load_hook();
    }

    function get_header_template()
    {
        $header_template = 'header_osc.tpl.html';

        // load platform specific headers
        switch (MH_PLATFORM) {
            case 'oscommerce':
                if (MH_PLATFORM_OSC_23) {
                    $header_template = 'header_osc23.tpl.html';
                }
                if (MH_PLATFORM_OSCMAX_25) {
                    $header_template = 'header_oscmax25.tpl.html';
                }
                if (MH_PLATFORM_TRUELOADED) {
                    $header_template = 'header_trueloaded.tpl.html';
                }
                break;
            case 'creloaded':
                if (mh_cfg('INSTALLED_VERSION_MAJOR') == 6 && mh_cfg('INSTALLED_VERSION_MINOR') == 2) {
                    $header_template = 'header_creloaded_62.tpl.html';
                } else {
                    $header_template = 'header_creloaded.tpl.html';
                }
                break;
            case 'digistore':
                $header_template = 'header_digistore.tpl.html';
                break;
            case 'zencart':
                $header_template = 'header_zc.tpl.html';
                break;
            case 'mercari':
                $header_template = 'header_mercari.tpl.html';
                break;
            case 'xtc':
                $header_template = 'header_xtc.tpl.html';

                if (MH_PLATFORM_XTC_SEO) {
                    $header_template = 'header_xtc_seo.tpl.html';
                }

                if (MH_PLATFORM_XTC_ECB) {
                    $header_template = 'header_xtc_ecb.tpl.html';
                }
                break;
            case 'gambio':
                if (MH_PLATFORM_GAMBIO == 1) {
                    $header_template = 'header_gambiogx.tpl.html';
                } elseif (MH_PLATFORM_GAMBIO >= 2.5) {
                    $header_template = 'header_gambiogx25.tpl.html';
                }
                break;
            default:
        }

        return $header_template;
    }

    function load_header()
    {
        if (mh_cfg('MH_CUSTOMER_INSIGHT_HEADER_LOADED')) {
            return false;
        }
        $header_template_file = $this->get_header_template();
        $header_template_path = $this->headers_template_dir . $header_template_file;

        if (file_exists($header_template_path)) {
            $this->smarty->setTemplateDir($this->headers_template_dir);
            $header_output = $this->smarty->fetch($header_template_file);
            mh_define('MH_CUSTOMER_INSIGHT_HEADER_LOADED', true);
            return $header_output;
        }
    }

    function load_hook_php()
    {
        $hook_php_file = $this->page . '.php';
        $hook_php_path = $this->hooks_template_dir . $hook_php_file;
        if (file_exists($hook_php_path)) {
            include_once($hook_php_path);
        }
    }

    function load_hook()
    {
        $hook_template_file = $this->page . '.tpl.html';
        $hook_template_path = $this->hooks_template_dir . $hook_template_file;

        if (file_exists($hook_template_path)) {
            $this->smarty->setTemplateDir($this->hooks_template_dir);
            $hook_output = $this->smarty->fetch($hook_template_file);
            $hook_header_output = $this->load_header();
            return $hook_header_output . $hook_output;
        }
    }
}
