<?php

/*
 MailBeez Automatic Trigger Email Campaigns
 http://www.mailbeez.com

 Copyright (c) 2010 - 2012 MailBeez

 Licensing Terms & Other Conditions of this
 Mailbeez Module:

 Unless you have our prior written consent, you must NOT directly or indirectly license,
 sub-license, sell, resell, or provide for free or make an offer to do any of these things.
 All of these things are strictly prohibited with this MailBeez Pro Module.

 One Purchase for one Shop - please contact cord@mailbeez.com for volume discounts and
 reseller agreements.

 OpenSource but not free - please respect this license agreement.

 */

mh_load_modules_language_files(MH_DIR_CONFIG, 'config_customer_insight');

class context_date
{
    function __construct()
    {

    }

    function context_date()
    {
        self::__construct();
    }

    public static function datetime_to_formated_date($datetime, $return_formated_datetime = NULL)
    {
        //convert datetime to timestamp
        if (trim($datetime) == '') return $datetime;
        $parts = explode(' ', $datetime);
        $date = explode('-', $parts[0]);
        $time = explode(':', $parts[1]);
        $datetime_timestamp = mktime($time[0], $time[1], $time[2], $date[1], $date[2], $date[0]);

        //Dateformat array
        $format_date = array(
            'german' => 'd.m.Y',
            'english' => 'd/m/Y',
            'danish' => 'd-m-Y',
            'french' => 'd/m/Y',
            'spanish' => 'd/m/Y',
            'netherlands' => 'd-m-Y',
            'dutch' => 'd-m-Y',
            'default' => 'd/m/Y');

        //Datetimeformat array
        $format_datetime = array(
            'german' => 'd.m.Y, H:i:s',
            'english' => 'd/m/Y, h:i:s a',
            'danish' => 'd-m-Y, H:i:s',
            'french' => 'd/m/Y, H:i:s',
            'spanish' => 'd/m/Y, H:i:s',
            'netherlands' => 'd-m-Y, H.i.s',
            'dutch' => 'd-m-Y, H.i.s',
            'default' => 'd/m/Y, H:i:s');

        if ($return_formated_datetime) {
            if (!$format_datetime[$_SESSION['language']]) $lang = 'default';
            else $lang = $_SESSION['language'];
            return date($format_datetime[$lang], $datetime_timestamp);
        } else {
            if (!$format_date[$_SESSION['language']]) $lang = 'default';
            else $lang = $_SESSION['language'];
            return date($format_date[$lang], $datetime_timestamp);
        }
    }


    public static function datetime_to_relativetime($datetime, $simple = false)
    {
        if (trim($datetime) == '') return $datetime;
        $parts = explode(' ', $datetime);
        $date = explode('-', $parts[0]);
        if ($parts[1] == '') $parts[1] = '00:00:00';
        $time = explode(':', $parts[1]);

        $time = mktime($time[0], $time[1], $time[2], $date[1], $date[2], $date[0]);

        $d[0] = array(1, 'MAILBEEZ_RELATIVETIME_SECOND');
        $d[1] = array(60, 'MAILBEEZ_RELATIVETIME_MINUTE');
        $d[2] = array(3600, 'MAILBEEZ_RELATIVETIME_HOUR');
        if ($simple) $d[3] = array(86400, 'MAILBEEZ_RELATIVETIME_SIMPLE_DAY');
        else $d[3] = array(86400, 'MAILBEEZ_RELATIVETIME_DAY');
        $d[4] = array(604800, 'MAILBEEZ_RELATIVETIME_WEEK');
        $d[5] = array(2592000, 'MAILBEEZ_RELATIVETIME_MONTH');
        $d[6] = array(31104000, 'MAILBEEZ_RELATIVETIME_YEAR');

        $w = array();

        $return = "";
        $now = time();
        $diff = ($now - $time);
        if ($diff < 0) $secondsLeft = $diff * -1;
        else $secondsLeft = $diff;
        $and = 0;

        for ($i = 6; $i > -1; $i--) {
            $w[$i] = intval($secondsLeft / $d[$i][0]);
            $secondsLeft -= ($w[$i] * $d[$i][0]);
            if ($w[$i] > 0) {

                if ($and == 1) {
                    if ($simple) continue;
                    $return .= ' ' . mh_lng('MAILBEEZ_RELATIVETIME_AND') . ' ';
                }
                if ($and > 1) continue;
                $return .= sprintf(constant($d[$i][1] . ($w[$i] > 1 ? 'S' : '')), $w[$i]);
                $last_i = $i;
                $and++;
            }

        }
        if (!$simple) $return = (($diff > 0) ? mh_lng('MAILBEEZ_RELATIVETIME_BEFORE') : mh_lng('MAILBEEZ_RELATIVETIME_IN')) . ' ' . $return;
        return $return;
    }

    //Calculate next Birthday
    public static function nextBirthdate($datetime)
    {
        $parts = explode(' ', $datetime);
        $date = explode('-', $parts[0]);
        if ($parts[1] == '') $parts[1] = '00:00:00';
        $nextBirthdate = mktime(0, 0, 0, $date[1], $date[2], date('Y'));

        $now = time();
        $diff = ($nextBirthdate - $now);

        if ($diff < 0) $date[0] = date('Y') + 1;
        else $date[0] = date('Y');

        return $date[0] . '-' . $date[1] . '-' . $date[2] . ' ' . $parts[1];

    }


}


?>