<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2013 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

 */


///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////


mh_define('TABLE_MAILBEEZ_NOTIFICATIONS', DB_PREFIX . 'mailbeez_notifications');

mh_define('MAILBEEZ_NOTIFICATIONS_AUTO_EXPIRE_DAYS', 3);
mh_define('MAILBEEZ_NOTIFICATIONS_AUTO_DELETE_DAYS', 30);

class notificationbeez
{

    var $autoExpired = false;

// class constructor
    function __construct()
    {

    }

    function notificationbeez()
    {
        self::__construct();
    }
// class methods


//    function add($title, $notification_summary, $notification, $module, $ref_id, $iteration = 1, $customers_id = null, $severity = 5, $link = null, $channel_id = 0, $status = 0)
    function add($param)
    {
        if (!$this->check_status()) {
            return false;
        }

        $sql_data_array = array(
            'title' => $param['title'],
            'notification_summary' => $param['notification_summary'],
            'notification' => $param['notification'],
            'ref' => $param['ref_id'], // unique references, e.g. order or timestamp
            'iteration' => (int)$param['iteration'],
            'module' => $param['module'],
            'customers_id' => ($param['customers_id'] == '') ? 0 : $param['customers_id'],
            'channel_id' => $param['channel_id'],
            'severity' => $param['severity'],
            'link' => $param['link'],
            'link_type' => $param['link_type'], // E - external, I - internal, P - popup
            'notification_only' => (isset($param['notification_only']) && $param['notification_only'] != '') ? true : false,
            'panel_click_action' => $param['panel_click_action'], // H - hide
            'status' => $param['status'],
            'date_added' => 'now()',
            'icon_style' => $param['icon_style']
        );
        $link_compare = $param['link'];
        if ($param['link_type'] != 'E') {
            $link_compare .= '#'.$param['ref_id'];
        }




        if ($this->getNotificationList(1, null, $param['module'], $param['customers_id'], null, null, $param['ref_id'], $link_compare)) {
            return false;
        }

        return mh_db_perform(TABLE_MAILBEEZ_NOTIFICATIONS, $sql_data_array);
    }

    function getNotificationList($limit = null, $id = null, $module = null, $customers_id = null, $channel_id = null, $status = null, $ref_id = null, $link = null)
    {
        if (!$this->check_status()) {
            return false;
        }

        $this->autoExpire();
        //$this->autoDelete(); // issue: addes blogpost as new

        $query_sql = " select * from " . TABLE_MAILBEEZ_NOTIFICATIONS . " where true ";

        if (!is_null($id)) {
            $query_sql .= " and id='" . $id . "'";
        } else {
            $query_sql .= (!is_null($module)) ? " and module='" . $module . "'" : '';
            $query_sql .= (!is_null($customers_id)) ? " and customers_id='" . $customers_id . "'" : '';
            $query_sql .= (!is_null($channel_id)) ? " and channel_id='" . $channel_id . "'" : '';

            if ( !is_null($ref_id) || !is_null($link) ) {
            $query_sql .= " and  (  ";
            $query_sql .= (!is_null($ref_id)) ? " ref='" . $ref_id . "'" : ' true ';
            $query_sql .= ' or ';
            $query_sql .= (!is_null($link)) ? " link='" . $link . "'" : ' true ';
            $query_sql .= ")";
            }

            $query_sql .= (!is_null($status)) ? " and status='" . $status . "'" : " ";

            $query_sql .= " order by severity ASC, date_added DESC";

            $query_sql .= (!is_null($limit)) ? " limit " . $limit : '';
        }

        $query = mh_db_query($query_sql);

        $result = array();

        while ($item = mh_db_fetch_array($query)) {
            // force https
            if (MH_REQUEST_TYPE == 'SSL') {
                $item['icon_style'] = str_replace('http://', 'https://', $item['icon_style']);
                $item['notification'] = str_replace('http://', 'https://', $item['notification']);
            }
            if ($item['notification_summary'] == '') {
                $item['notification_summary'] = $item['notification'];
            }

            $result[] = $item;
        }
        return (count($result) > 0) ? $result : array();
    }

    function getNotification($id)
    {
        return $this->getNotificationList(null, $id);
    }

    function getOpenNotificationList($limit = null, $id = null, $module = null, $customers_id = null, $channel_id = null, $status = null, $ref_id = null)
    {
        return $this->getNotificationList($limit, $id, $module, $customers_id, $channel_id, 0, $ref_id);
    }


    function getDismissedNotificationList()
    {
        return $this->getNotificationList(50, null, null, null, null, 1);
    }

    function getNotificationCount($status = 0, $module = null, $customers_id = null)
    {
        $result = $this->getOpenNotificationList(null, null, $module, $customers_id, null, $status);

        if (is_array($result)) {
            return sizeof($result);

        }
        return false;
    }

    // delete notifications for $module
    function deleteNotification($module = null, $delay = 0, $ref = 0)
    {
        $query_sql = "delete from " . TABLE_MAILBEEZ_NOTIFICATIONS . " where true ";

        if (!is_null($module)) {
            $query_sql .= " and module='" . $module . "'";
        }

        if ($delay > 0) {
            $query_sql .= " and DATE(date_added) <= DATE(SUBDATE(now(), $delay))";
        }
        if ($ref > 0) {
            $query_sql .= " and ref='$ref'";
        }
        $query = mh_db_query($query_sql);
        return true;
    }

    function updateStatus($notification_id, $status = 1)
    {
        if (!$this->check_status()) {
            return false;
        }

        if (!$notification_id > 0) {
            return false;
        }

        $sql_data_array = array(
            'status' => $status,
            'last_modified' => 'now()'
        );

        return mh_db_perform(TABLE_MAILBEEZ_NOTIFICATIONS, $sql_data_array, 'update', 'id=' . $notification_id);
    }

    function hide($notification_id)
    {
        return $this->updateStatus($notification_id);
    }

    function unhide($notification_id)
    {
        return $this->updateStatus($notification_id, 0);
    }

    static function reset_notifications()
    {
        return mh_db_query("TRUNCATE TABLE " . TABLE_MAILBEEZ_NOTIFICATIONS);
    }

    function check_status()
    {
        if (mh_cfg('MAILBEEZ_INSIGHT_NOTIFICATION_STATUS', 'False') == 'False') {
            return false;
        }
        return true;
    }

    function autoExpire()
    {
        if (!$this->autoExpired) {
            mh_db_query('update ' . TABLE_MAILBEEZ_NOTIFICATIONS . ' set status=1, last_modified=now() where date_added < SUBDATE(now(), INTERVAL ' . mh_cfg('MAILBEEZ_NOTIFICATIONS_AUTO_EXPIRE_DAYS') . ' DAY)  and status=0 ');
            $this->autoExpired = true;
        }

    }

    function autoDelete()
    {
        $this->deleteNotification(null, mh_cfg('MAILBEEZ_NOTIFICATIONS_AUTO_DELETE_DAYS'));
    }
}

// end of class
