<?php

// observer pattern
// http://sourcemaking.com/design_patterns/observer/php
// http://www.d-mueller.de/blog/5-php-patterns-im-schnelldurchlauf-factory-iterator-observer-singleton-strategy/

interface Subject
{
    public function addObserver(Observer $Observer);

    public function removeObserver(Observer $Observer);

    public function notify();
}

class MailBeezNotifier implements Subject
{
    var $_observers = array();

    public function addObserver(Observer $observer)
    {
        $this->_observers[] = $observer;
    }

    public function removeObserver(Observer $observer)
    {
        for ($i = 0; $i < count($this->_observers); $i++) {
            if ($this->_observers[$i] === $observer) {
                unset($this->_observers[$i]);
                break;
            }
        }
    }

    public function notify()
    {
        foreach ($this->_observers as $o)
            $o->observer_update($this);
    }
}

interface Observer
{
    public function observer_update(Subject $Subject);
}