<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/viewbeez.php');


class view_customer extends viewbeez
{

// class constructor
    function __construct($email = NULL)
    {
        parent::__construct();

        $this->code = 'view_customer';
        $this->module = 'view_customer';
        $this->version = '1.0';
        $this->title = mh_lng('MAILBEEZ_VIEW_CUSTOMER_TITLE');
        $this->description = mh_lng('MAILBEEZ_VIEW_CUSTOMER_DESCRIPTION');

        $this->icon = 'icon_m.png';
        $this->sort_order = -1000;
        $this->enabled = true;
        $this->set_template();
    }

    function view_customer($email = NULL)
    {
        return self::__construct($email);
    }

    function get_view_content($template)
    {
        if ($this->customer->id === null) {
            return '';
        }

        $smarty = $this->init_view_content($template);

        $smarty->assign('email', htmlentities($this->customer->email));
        $smarty->assign('name', htmlentities($this->customer->firstname . ' ' . $this->customer->lastname));
        $smarty->assign('company', htmlentities($this->customer->def_addr_company));
        $smarty->assign('status', htmlentities($this->customer->status_name));
        $smarty->assign('street', htmlentities($this->customer->def_addr_street_address));
        $smarty->assign('postcode', htmlentities($this->customer->def_addr_postcode));
        $smarty->assign('countrycode', htmlentities($this->customer->def_addr_country_code));
        $smarty->assign('telephone', htmlentities($this->customer->telephone));
        $smarty->assign('city', htmlentities($this->customer->def_addr_city));
        $smarty->assign('state', htmlentities($this->customer->def_addr_state));
        $smarty->assign('birthdate', htmlentities(mh_date_short($this->customer->birthdate)));
        $smarty->assign('birthdate_relative', htmlentities(context_date::datetime_to_relativetime($this->customer->next_birthdate)));
        $smarty->assign('date_added', htmlentities(mh_datetime_short($this->customer->date_added, 1)));
        $smarty->assign('date_added_relative', htmlentities(context_date::datetime_to_relativetime($this->customer->date_added)));
        $smarty->assign('date_last_modiefied', htmlentities(mh_datetime_short($this->customer->date_last_modiefied)));
        $smarty->assign('date_last_modiefied_relative', htmlentities(context_date::datetime_to_relativetime($this->customer->date_last_modiefied)));
        $smarty->assign('date_last_order', htmlentities(mh_datetime_short($this->customer->date_last_order, 1)));
        $smarty->assign('date_last_order_relative', htmlentities(context_date::datetime_to_relativetime($this->customer->date_last_order)));
        $smarty->assign('all_addresses', $this->get_all_addresses());
        $smarty->assign('whos_online', $this->get_whos_online());
        $smarty->assign('turnover', (mh_price($this->get_total_turnover())));
        $smarty->assign('turnover_this_year', (mh_price($this->get_total_turnover(date('Y-01-01')))));
        $smarty->assign('turnover_this_month', (mh_price($this->get_total_turnover(date('Y-m-01')))));
        $smarty->assign('turnover_last_month', (mh_price($this->get_total_turnover(date('Y-m-01', mktime(0, 0, 0, date('m') - 1, 01, date('Y'))), date('Y-m-01', mktime(0, 0, 0, date('m') - 1, 31, date('Y')))))));
        $smarty->assign('turnover_last_year', (mh_price($this->get_total_turnover(date('Y-m-01', mktime(0, 0, 0, 01, 01, date('Y') - 1)), date('Y-m-01', mktime(0, 0, 0, 12, 31, date('Y') - 1))))));
        $smarty->assign('user_image', $this->customer->user_image);

        return $this->parse_view_content($smarty, $template);
    }

    function get_view_summary()
    {
        $smarty = $this->init_view_summary();
        $smarty->assign('name', htmlentities($this->customer->firstname . ' ' . $this->customer->lastname));
        $smarty->assign('customer', $this->customer);
        $smarty->assign('company', htmlentities($this->customer->def_addr_company));
        $smarty->assign('status', htmlentities($this->customer->status_name));
        $smarty->assign('street', htmlentities($this->customer->def_addr_street_address));
        $smarty->assign('postcode', htmlentities($this->customer->def_addr_postcode));
        $smarty->assign('countrycode', htmlentities($this->customer->def_addr_country_code));
        $smarty->assign('telephone', htmlentities($this->customer->telephone));
        $smarty->assign('city', htmlentities($this->customer->def_addr_city));
        $smarty->assign('state', htmlentities($this->customer->def_addr_state));
        $smarty->assign('birthdate', htmlentities(mh_date_short($this->customer->birthdate)));
        $smarty->assign('birthdate_relative', htmlentities(context_date::datetime_to_relativetime($this->customer->next_birthdate)));
        $smarty->assign('date_added', htmlentities(mh_datetime_short($this->customer->date_added, 1)));
        $smarty->assign('date_added_relative', htmlentities(context_date::datetime_to_relativetime($this->customer->date_added)));
        $smarty->assign('date_last_modiefied', htmlentities(mh_datetime_short($this->customer->date_last_modiefied)));
        $smarty->assign('date_last_modiefied_relative', htmlentities(context_date::datetime_to_relativetime($this->customer->date_last_modiefied)));
        $smarty->assign('date_last_order', htmlentities(mh_datetime_short($this->customer->date_last_order, 1)));
        $smarty->assign('date_last_order_relative', htmlentities(context_date::datetime_to_relativetime($this->customer->date_last_order)));

    }

    function get_all_addresses()
    {
        $query_sql = " SELECT * FROM " . TABLE_ADDRESS_BOOK . " a INNER JOIN " . TABLE_COUNTRIES . " c ON a.entry_country_id = c.countries_id WHERE a.customers_id = '" . $this->customer->id . "' AND a.address_book_id <> '" . $this->customer->default_address_id . "'";
        $query = mh_db_query($query_sql);
        $addresses = array();
        while ($row = mh_db_fetch_array($query)) {
            array_push($addresses, $row);
        }
        return $addresses;
    }

    function get_whos_online()
    {
        $query_sql = "SELECT * FROM " . TABLE_WHOS_ONLINE . " WHERE customer_id = '" . $this->customer->id . "' ORDER BY time_last_click";
        $query = mh_db_query($query_sql);
        $data = array();
        while ($row = mh_db_fetch_array($query)) {
            $row['time_entry'] = date("d.m.Y H:m:s", $row['time_entry']);
            $row['time_last_click'] = date("d.m.Y H:m:s", $row['time_last_click']);
            array_push($data, $row);
        }
        return $data;
    }

    function get_total_turnover($date_from = null, $date_to = null)
    {
        $query_sql = "SELECT sum(value) as turnover FROM " . TABLE_ORDERS_TOTAL . " ot INNER JOIN " . TABLE_ORDERS . " o ON ot.orders_id = o.orders_id WHERE ( o.customers_id = '" . $this->customer->id . "' OR o.customers_email_address = '" . $this->customer->email . "') AND ot.class = 'ot_total' ";

        if ($date_from) $query_sql .= " AND o.date_purchased >= '" . $date_from . "'";
        if ($date_to) $query_sql .= " AND o.date_purchased <= '" . $date_to . "'";
        $query = mh_db_query($query_sql);
        $row = mh_db_fetch_array($query);
        return $row['turnover'];
    }


    function get_menu_entry()
    {
        if ($this->customer->id === 0) {
            return '';
        }
        ob_start()
        // workaround to get menu icon
        ?>
        <li <?php if (mh_get('view_module') == $this->module) { ?>
            class="ui-btn-active"
        <?php } ?>
            class="ui-bar-d"
            id="menu-divider" data-theme="c"
        >
            <a href="<?php echo $this->get_menu_link(); ?>">

                <?php if (stristr($this->customer->user_image, 'gravatar')) { ?>
                    <img src="<?php echo $this->customer->user_image; ?>" width="40"
                         style="margin-left: 5px;margin-top:4px;">
                <?php } else { ?>
                    <div class="nameBadge nameBadgeCustomer ui-li-thumb" style="margin-left: 5px;margin-top:4px;text-shadow: none"><?php echo htmlentities($this->customer->firstname . ' ' . $this->customer->lastname); ?></div>
                <?php } ?>
                <?php if ($this->customer->hasHardBounce) {
                    ?>
                    <div class="engagement_badge bounced" style="float:right">BOUNCED</div>
                    <?php
                }?>

                <div style="padding-left: 0px; font-weight: normal; overflow: hidden;
          text-overflow: ellipsis;
          white-space: nowrap;">
                    <?php echo htmlentities($this->customer->firstname . ' ' . $this->customer->lastname); ?>
                    <br/>
                    <?php echo htmlentities($this->customer->def_addr_country_code . '-' . $this->customer->def_addr_postcode . ' ' . $this->customer->def_addr_city) ?>
                </div>

            </a>

        </li>
        <?php
        return ob_get_clean();

    }

}
