<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/viewbeez.php');

mh_define('FILENAME_PRODUCT_INFO', 'product_info.php');

class view_products extends viewbeez
{

// class constructor
    public $module;
    public $version;

    public $title;

    public $description;
    public $sort_order;
    public $menu_cnt_default;

    function __construct()
    {
        parent::__construct();

        $this->code = 'view_products';
        $this->module = 'view_products';
        $this->version = '2.0';
        $this->title = mh_lng('MAILBEEZ_VIEW_PRODUCTS_TITLE');
        $this->description = mh_lng('MAILBEEZ_VIEW_PRODUCTS_DESCRIPTION');

        $this->sort_order = 30;
        $this->enabled = true;
        $this->set_template();

        $this->menu_cnt_default = $this->cnt_products();
    }



    function get_view_content($template)
    {
        $smarty = $this->init_view_content($template);
        // implement logic to get data
        // assign to smarty template variables

        // $smarty->assign(array('products' => $products_data_array));
        // $smarty->assign('name' => $name);

//        $purchased_products_result = mh_insight_order::get_order_product_list($this->customer->id);


        $products_array = $this->get_bought_products($this->customer->id);
        $smarty->assign('products', $products_array);

        $smarty->assign('get_products_url', mh_href_link(FILENAME_MAILBEEZ, 'app=load_app&app_path=config_customer_insight/admin_application_plugins/datagrid.php&app_action=get_products&customers_id=' . $this->customer->id));

        $smarty->assign('MAILBEEZ_ORDER_DG_PAGE_SIZE', 900);
        $smarty->assign('customers_id', $this->customer->id);

        return $this->parse_view_content($smarty, $template);
    }

    function get_view_summary()
    {
        $products_array = $this->get_bought_products($this->customer->id);

        /*
        if (is_array($products_array)) {
            foreach ($products_array as $key => $product) {
                $products_image = $product['products_image'];
                $products_image_src = mh_product_image_src(mh_admin_product_image(array('products_image' => $products_image, 'products_name' => $product['products_name'])));
                $products_array[$key]['products_image_src'] = $products_image_src;
            }
        }

        */

        $smarty = $this->init_view_summary();
        $smarty->assign('bought_products', $products_array);

        return $this->parse_view_summary($smarty);
    }

    function get_view_la_widget()
    {
        $limit = 5;

        $products_array = $this->get_bought_products($this->customer->id, $limit);

        /*
        if (is_array($products_array)) {

            foreach ($products_array as $key => $product) {
                $products_image = $product['products_image'];
                $products_image_src = mh_product_image_src(mh_admin_product_image(array('products_image' => $products_image, 'products_name' => $product['products_name'])));
                $products_array[$key]['products_image_src'] = $products_image_src;
            }
        }

        */

        $smarty = $this->init_view_la_widget();
        $smarty->assign('bought_products', $products_array);
        $smarty->assign('more_products', $this->cnt_products() - $limit);


        return $this->parse_view_la_widget($smarty);
    }


    function get_bought_products($customer_id, $limit = 100)
    {
        if ((int)$customer_id == 0) {
            return array();
        }


        $this->set_cache_id('purchased_products', $customer_id);

        if ($cache = $this->read_cache()) {
            $return = $cache['value'];
            return (is_array($return)) ? array_slice($return, 0, $limit) : $return;
        }

        $purchased_products_result = mh_insight_order::get_order_product_list($customer_id);
        $data = mh_arr_val($purchased_products_result, 'rows');


        $product_page = (MH_PLATFORM == 'zencart') ? 'index.php?main_page=' . mh_fn('FILENAME_PRODUCT_INFO') . '&' : mh_fn('FILENAME_PRODUCT_INFO') . '?';

        $data_cache = array();

        if (is_array($data)) {
            foreach ($data as $key => $product) {

                // p.products_id, p.products_image, op.products_name, op.products_price, sum(op.products_quantity) as quantity

                $data_cache[$key]['products_id'] = $data[$key]['products_id'];
                $data_cache[$key]['products_model'] = $data[$key]['products_model'];
                $data_cache[$key]['products_name'] = $data[$key]['products_name'];
                $data_cache[$key]['products_price'] = $data[$key]['products_price'];
                $data_cache[$key]['total_quantity'] = $data[$key]['total_quantity'];
                $data_cache[$key]['products_description'] = substr(strip_tags($data[$key]['products_description']), 0, 200);
                $data_cache[$key]['turnover'] = $data[$key]['turnover'];
                $data_cache[$key]['products_image_src'] = $data[$key]['products_image_src'];
                $data_cache[$key]['link_shop'] = MH_CATALOG_SERVER . MH_DIR_WS_CATALOG . $product_page . 'products_id=' . $data[$key]['products_id'];
                $data_cache[$key]['link_admin'] = mh_href_link(FILENAME_PRODUCT, 'action=new_product&pID=' . $data[$key]['products_id'] . '&search=' . urlencode($data[$key]['products_name']));
//                $data[$key]['link_admin'] = mh_href_link(FILENAME_CATEGORIES, 'search=' . urlencode( $data[$key]['products_name']) );
            }
        }

        $return = $this->set_cache($data_cache);
        return (is_array($return)) ? array_slice($return, 0, $limit) : $return;
    }

    function cnt_products()
    {
        return sizeof($this->get_bought_products($this->customer->id));
    }

}

