<?php
/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2014 MailBeez

  Licensing Terms & Other Conditions of this
  Mailbeez Module:

  Unless you have our prior written consent, you must NOT directly or indirectly license,
  sub-license, sell, resell, or provide for free or make an offer to do any of these things.
  All of these things are strictly prohibited with this MailBeez Pro Module.

  One Purchase for one Shop - please contact cord@mailbeez.com for volume discounts and
  reseller agreements.

  OpenSource but not free - please respect this license agreement.

 */

require_once(MH_DIR_CONFIG . 'config_email_engine_n2g/classes/newsletter2go.class.php');

$nl2g_status = false;
$nl2g_reg_status = false;
$nl2g_error = false;
$nl2g_error_msg = '';

if (mh_cfg('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_API_KEY') && ('Newsletter2Go' == mh_cfg('MAILBEEZ_CONFIG_EMAIL_ENGINE'))) {

    try {
        $nl2go = new newsletter2go(mh_cfg('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_API_KEY'));
        $credits = $nl2go->getCredits();

        if ($credits['success']) {
            $nl2g_status = true;
            $nl2g_reg_status_value = $nl2go->getStatus();
            $nl2g_reg_status = $nl2g_reg_status_value['value'];

        } else {
            $nl2g_error = true;
            $nl2g_error_msg = $credits['reason'];
        }

    } catch (Exception $e) {
        print_r($e->getMessage());
    }
}

//


$plugin_actions = mb_admin_button(mh_href_link(mh_fn('FILENAME_MAILBEEZ'), 'app=load_app&app_path=config_email_engine_n2g/admin_application_plugins/register.php'), mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_BUTTON'), '', 'popup', 'button', '', 'document', 'iframe width:1000 height:390');


$msg = '';

if (mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_DE_ONLY')) {
    $contents[] = array('text' => '<div style="color: #f00">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_DE_ONLY') . '</div>');
}

if ($nl2g_status) {

    $contents[] = array('text' => '<div class="mb_action_box" style="background-color: #fff">
    <div class="mb_action_box text">' . '<img src="' . $config_module_directory_ws . 'config_email_engine_n2g/images/logo.png" width="300" height="52" vspace="20" hspace="5" style="margin: 30px 30px;">' .
        (($nl2g_reg_status) ?
            '<div class="mb_action_box text">
                                <div align="center" style="width:95%; margin: auto; position: relative; margin-top: 0px; margin-bottom: 15px;"><div style="border: 1px solid green; padding: 10px;">' . MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REG_STATUS_OK .  '

                                </div></div>
                        </div>' :
            '<div class="mb_action_box text">
                    <div align="center" style="width:95%; margin: auto; position: relative; margin-top: 0px; margin-bottom: 15px;"><div style="border: 1px solid red; padding: 10px;">' . MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REG_STATUS .  '<br><br>
                    <a href="#" onclick="document.location.reload(); return false;">' . MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REG_STATUS_CHECK .'</a>

                    </div></div>
            </div>' ) .
        ' ' . '</div>
        <div class="mb_action_box headline"><div align="center">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_CREDITS') . '</div></div>

        <div align="center" style="width:85%; margin: auto; position: relative; margin-top: 15px; margin-bottom: 15px;">' .
        '<div class="mb_action_box text" style="float:left; border: 1px solid #c0c0c0; width: 33%; height: 80px; text-align: center">' .
        '<div style="font-size: 20px;padding-top: 10px;padding-bottom: 7px">' . $credits['value']['freemailcount'] . '</div>' .
        MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_FREEMAILCOUNT . '</div>' .
        '<div class="mb_action_box text" style="float:left; border: 1px solid #c0c0c0; border-left: 0px; width: 32%; height: 80px; text-align: center">' .
        '<div style="font-size: 20px;padding-top: 10px;padding-bottom: 7px">' . $credits['value']['emailcount'] . '</div>' .
        MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_EMAILCOUNT . '</div>' .
        '<div class="mb_action_box text" style="float:left; border: 1px solid #c0c0c0; border-left: 0px; width: 33%; height: 80px; text-align: center">' .
        '<div style="font-size: 20px;padding-top: 10px;padding-bottom: 7px">' . $credits['value']['abocount'] . '</div>' .
        MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_ABOCOUNT .


        '</div>
        <br clear="both">
        </div>
        <div class="mb_action_box text">
        <div align="center"><a href="' . MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_LOAD_URL . '" target="_blank" style="font-weight: bold">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_CREDITS_BUY_BUTTON') . '</a></div>
        <br>
        </div><div class="mb_action_box text" id="MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_SPF_HINT"><div align="center" style="width:95%; margin: auto; position: relative; margin-top: 0px; margin-bottom: 15px;"><div style="border: 1px solid #c0c0c0; padding: 10px;">' .sprintf(MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_SPF_HINT, $_SERVER['SERVER_NAME'], 'include:nl2go.com') . '
        </div></div></div>');

} else {

    if ($nl2g_error) {
        // $nl2g_error_msg
        $contents[] = array('text' => '<div class="mb_action_box">
                <div class="mb_action_box headline">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_ERROR_HEADLINE') . '</div>
                <div class="mb_action_box text">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_ERROR_TEXT') . '</div>
                <div class="mb_action_box text"><div align="center" style="font-weight: bold; color: #f00">' . $nl2g_error_msg . '</div></div>
                </div>');
    }


    $contents[] = array('text' => '<div class="mb_action_box" style="background-color: #fff">
        <div class="mb_action_box text">' . '<img src="' . $config_module_directory_ws . 'config_email_engine_n2g/images/logo.png" width="300" height="52"  vspace="20" hspace="5" style="margin: 30px 30px;">' . '</div>

        <div style="padding: 15px; padding-top: 5px">
        <div class="mb_action_box headline">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_HEADLINE') . '<br><br></div>
        <div class="mb_action_box text">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_TEXT') . '<br><br></div>
        <div class="mb_action_box buttons" style="clear: both"><div align="center">' . $plugin_actions . '<br><br></div></div>
        <div class="mb_action_box text">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_INFO_TEXT') . '<br><br></div>
        <div class="mb_action_box text"><div align="center">' . $msg . '</div></div></div>
        </div>');
//}

}
