<?php

/*
 * MailBeez Aps 2014
 *
 *
 * current limitations
 * ---------------------------
 *
 * getCustomers:
 *  - it is not possible to select changes to customers by "hours"
 *
 * getProductInfo:
 *  - only main image
 *
 * setUnsubscribe
 *  - not yet implemented
 *
 * setBounce
 *  - not yet implemented
 *
 * setUnsubscribe
 *  - not yet implemented
 *
 */

class api_newsletter2go
{

    public function testConnection()
    {
        $data = array('result' => true);
        return $this->handleRequest($data);
    }

    public function getShopName()
    {
        $data = array('result' => 'MailBeez');
        return $this->handleRequest($data);
    }

    public function getShopPrefix()
    {
        $data = array('result' => 'mbz');
        return $this->handleRequest($data);
    }


    public function getCustomers($params)
    {
        $hours = $params['hours'];
        $newsletterSubscribersOnly = $params['newsletterSubscribersOnly'];

        $query_raw = "select c.customers_firstname, c.customers_lastname, c.customers_gender, c.customers_email_address, c.customers_dob, date_format(c.customers_dob, '%d.%m.%Y') as date_of_birth
                    from " . TABLE_CUSTOMERS . " c where true";

        $query_raw .= (($newsletterSubscribersOnly) ? " and customers_newsletter = 1 " : '');

        $query = mh_module_query($this, $query_raw);

        $customer_data = array();
        while ($item = mh_db_fetch_array($query)) {
            $customer_data[] = array('firstname' => $item['customers_firstname'],
                'lastname' => $item['customers_lastname'],
                'gender' => $item['customers_gender'],
                'mail' => $item['customers_email_address'],
                'mobile' => null,
                'birthday' => $item['date_of_birth'],
            );
        }

        $data = array('result' => $customer_data);

        return $this->handleRequest($data);
    }

    public function setBounce($email)
    {
        // todo
        $data = array('result' => 0);
        return $this->handleRequest($data);
    }


    public function setUnsubscribe($email)
    {
        // todo
        $data = array('result' => 0);
        return $this->handleRequest($data);
    }


    public function getProductInfo($params)
    {
        $identifier = $params['identifier'];
        $language_code = $params['language'];

        if (!isset($lng) || (isset($lng) && !is_object($lng))) {
            if (!class_exists('language')) {
                include(DIR_WS_CLASSES . 'language.php');
            }
            $lng = new language;
        }
        $lang_info = $lng->catalog_languages[$language_code];
        $language_id = $lang_info['id'];

        $query_products_raw = "select distinct p.products_model, p.products_image,  p.products_id, pd.products_name, pd.products_description, p.products_price, p.products_tax_class_id, IF(s.status, s.specials_new_products_price, NULL) as specials_new_products_price, IF(s.status, s.specials_new_products_price, p.products_price) as final_price , IF(s.status, p.products_price, s.specials_new_products_price) as old_price
                                from " . TABLE_PRODUCTS . " p
                                    join " . TABLE_PRODUCTS_DESCRIPTION . " pd on (p.products_id = pd.products_id)
                                     left join " . TABLE_SPECIALS . " s on p.products_id = s.products_id
                                where p.products_status = '1'
                                    and p.products_id = " . (int)$identifier . "
                                    and pd.language_id = '" . (int)$language_id . "' limit 1";

        //$data = array('result' => $query_products_raw);
        //return $this->handleRequest($data);

        $query_products = mh_db_query($query_products_raw);

        $products_data = array();
        while ($products_array = mh_db_fetch_array($query_products)) {
            $link = mh_href_email_link(mh_fn('FILENAME_PRODUCT_INFO'), 'products_id=' . $products_array['products_id']);

            $image = '';
            if (mh_not_null($products_array['products_image'])) {
                $image = mh_product_image_src(mh_product_image($products_array));
                $image = str_replace('thumbnail', 'info', $image);
            }
            $image_array = array();
            $image_array[] = $image;
            $url_data = parse_url($link);
            $url = $url_data['scheme'] . '://' . $url_data['host']; // . $url_data['path'];

            $products_data = array(
                'itemId' => $products_array['products_id'],
                'name' => $products_array['products_name'],
                'oldPrice' => $products_array['old_price'],
                'newPrice' => $products_array['final_price'],
                'url' => $url,
                'link' => $link,
                'shortDescription' => $products_array['products_name'] . ' ' . $products_array['products_model'], // todo: limit
                'description' => $products_array['products_description'],
                'images' => $image_array
            );
        }


        $data = array('result' => $products_data);

        return $this->handleRequest($data);
    }


    public function checkApiKey($api_key)
    {
        return ($api_key == mh_cfg('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_API_KEY'));
    }


    function handleRequest($data)
    {
        $json = json_encode($data, true);
        return $json;
    }

}
