<?php

require_once(MH_DIR_CONFIG . 'config_gdpr_export/classes/gdprbeez.php');


class gdpr_core_tracking extends gdprbeez
{

    public function __construct()
    {
        parent::__construct();
        $this->sort_order = 10;
        $this->code = 'tracking';
        $this->storedata = false;
        $this->prospect_enabled = true;
        $this->title = mh_lng('MAILBEEZ_GDPR_TRACKING_TITLE');
        $this->description = mh_lng('MAILBEEZ_GDPR_TRACKING_DESCRIPTION');
    }

    public function readData()
    {
        // MailBeez Core
        // OK MAILBEEZ_TRACKING
        // OK MAILBEEZ_TRACKING_CLICKS
        // OK MAILBEEZ_TRACKING_ORDERS
        // OK MAILBEEZ_BLOCK
        // OK MAILBEEZ_OPENS_LOG
        //
        // MAILBEEZ_BOUNCES
        //

        mh_define('TABLE_MAILBEEZ_TRACKING', DB_PREFIX . 'mailbeez_tracking');
        mh_define('TABLE_MAILBEEZ_BLOCK', DB_PREFIX . 'mailbeez_block');
        mh_define('TABLE_MAILBEEZ_BOUNCE', DB_PREFIX . 'mailbeez_bounces');
        mh_define('TABLE_MAILBEEZ_BOUNCE_MSG_LOG', DB_PREFIX . 'mailbeez_bounces_msg_log');

        mh_define('TABLE_MAILBEEZ_TRACKING_CLICKS', DB_PREFIX . 'mailbeez_tracking_clicks');
        mh_define('TABLE_MAILBEEZ_TRACKING_ORDERS', DB_PREFIX . 'mailbeez_tracking_orders');

        // Table mapping
        $mapping = array();
        $mapping[TABLE_MAILBEEZ_TRACKING] = array(
            'alias' => 'tr',
            'fields' => array('message_id' => 'message_id', 'module' => 'module', 'iteration' => 'iteration', 'customers_email' => 'email', 'orders_id' => 'reference', 'date_sent' => 'sent', 'opened' => 'opened', 'clicked' => 'clicked', 'ordered' => 'ordered', 'coupon_redeemed' => 'coupon_redeemed'));

        $data_columns = $this->buildColumns($mapping);

        $sql = "SELECT {$data_columns}
                    FROM " . TABLE_MAILBEEZ_TRACKING . " tr
                    WHERE customers_id =" . $this->getContactId();


        $result_raw = $this->_db($sql);
        $result_opens_array = array();
        $result_clicks_array = array();
        $result_orders_array = array();
        $result_block_array = array();
        foreach ($result_raw as $key => $row) {

            $sql_opens_log = "SELECT ol.message_id, ol.date, ol.user_agent
                        FROM " . TABLE_MAILBEEZ_OPENS_LOG . " ol
                        WHERE message_id ='" . $row['message_id'] . "'";

            $result_opens_raw = $this->_db($sql_opens_log);
            $result_opens_array = array_merge($result_opens_array, $result_opens_raw);


            $sql_clicks = "SELECT cl.message_id, cl.date_record as date, cl.url
                        FROM " . TABLE_MAILBEEZ_TRACKING_CLICKS . " cl
                        WHERE message_id ='" . $row['message_id'] . "'";
            $result_clicks_raw = $this->_db($sql_clicks);
            $result_clicks_array = array_merge($result_clicks_array, $result_clicks_raw);


            $sql_orders = "SELECT o.message_id, o.date_record as date, o.orders_id as order_id
                        FROM " . TABLE_MAILBEEZ_TRACKING_ORDERS . " o
                        WHERE message_id ='" . $row['message_id'] . "'";
            $result_orders_raw = $this->_db($sql_orders);
            $result_orders_array = array_merge($result_orders_array, $result_orders_raw);
        }

        $sql_block = "SELECT b.module, b.date_block as date
                        FROM " . TABLE_MAILBEEZ_BLOCK . " b
                        WHERE customers_id ='" . $this->getContactId() . "'";
        $result_block_raw = $this->_db($sql_block);
        $result_block_array = array_merge($result_block_array, $result_block_raw);


        $result_opens = $this->flatten($result_opens_array, 'open');
        $result_clicks = $this->flatten($result_clicks_array, 'click');
        $result_orders = $this->flatten($result_orders_array, 'orders');
        $result_sent = $this->flatten($result_raw, 'sent');
        $result_block = $this->flatten($result_block_array, 'block');

        return array_merge($result_sent, $result_opens, $result_clicks, $result_orders, $result_block);
    }
}
