<?php

require_once(MH_DIR_CONFIG . 'config_gdpr_export/classes/gdprbeez.php');


class gdpr_store_customer extends gdprbeez
{


    public function __construct()
    {
        parent::__construct();
        $this->sort_order = 1;
        $this->code = 'customer';
        $this->storedata = true;
        $this->title = mh_lng('MAILBEEZ_GDPR_STORE_CUSTOMERS_TITLE');
        $this->description = mh_lng('MAILBEEZ_GDPR_STORE_CUSTOMERS_DESCRIPTION');
    }

    public function readData()
    {
        // Table mapping
        $mapping = array();
        $mapping[TABLE_CUSTOMERS] = array(
            'alias' => 'c',
            'fields' => array('customers_date_added' => 'date_of_consent', 'customers_gender' => 'gender', 'customers_firstname' => 'firstname', 'customers_lastname' => 'lastname', 'customers_email_address' => 'email', 'customers_vat_id' => 'vat_id', 'customers_telephone' => 'phone', 'customers_fax' => 'fax'));
        $mapping[TABLE_ADDRESS_BOOK] = array(
            'alias' => 'ab',
            'fields' => array('entry_company' => 'company', 'entry_street_address' => 'street', 'entry_postcode' => 'zipcode', 'entry_city' => 'city'));
        $mapping[TABLE_COUNTRIES] = array(
            'alias' => 'co',
            'fields' => array('countries_name' => 'country'));

        $data_columns = $this->buildColumns($mapping);

        $sql = "SELECT $data_columns 
        		 FROM " . TABLE_CUSTOMERS . " c
        		 JOIN " . TABLE_ADDRESS_BOOK . " ab ON c.customers_id = ab.customers_id 
        		 JOIN " . TABLE_COUNTRIES . " co ON co.countries_id = ab.entry_country_id
        		 WHERE c.customers_id = " . $this->getContactId();

        $result = $this->_db($sql);
        return $result;
    }

}