<?php

require_once(MH_DIR_CONFIG . 'config_gdpr_export/classes/gdprbeez.php');


class gdpr_store_orders extends gdprbeez
{

    public function __construct()
    {
        parent::__construct();
        $this->sort_order = 2;
        $this->code = 'orders';
        $this->storedata = true;
        $this->title = mh_lng('MAILBEEZ_GDPR_ORDERS_TITLE');
        $this->description = mh_lng('MAILBEEZ_GDPR_ORDERS_DESCRIPTION');
    }

    public function readData()
    {
        // Table mapping orders
        $mapping = array();
        $mapping[TABLE_ORDERS] = array(
            'alias' => 'o',
            'fields' => array(
                'orders_id' => 'order_id',
                'date_purchased' => 'date',
                'customers_ip' => 'IP',
                'comments' => 'comment',
                'customers_name' => 'customer_name',
                'customers_street_address' => 'customer_address',
                'customers_postcode' => 'customer_zipcode',
                'customers_city' => 'customer_city',
                'delivery_name' => 'delivery_name',
                'delivery_street_address' => 'delivery_address',
                'delivery_postcode' => 'delivery_zipcode',
                'delivery_city' => 'delivery_city',
                'billing_name' => 'billing_name',
                'billing_street_address' => 'billing_address',
                'billing_postcode' => 'billing_zipcode',
                'billing_city' => 'billing_city',
                'language' => 'language',
                'payment_method' => 'payment_method'
            )
        );
        $data_columns_order = $this->buildColumns($mapping);

        $sql = "SELECT {$data_columns_order}
                FROM " . TABLE_ORDERS . " o
                WHERE customers_id = " . $this->getContactId();

        $result_orders = $this->_db($sql);


        // Table mapping products
        $mapping = array();

        $mapping[TABLE_ORDERS_PRODUCTS] = array(
            'alias' => 'op',
            'fields' => array('orders_products_id' => 'product_id', 'products_quantity' => 'quantity', 'products_name' => 'name', 'products_price' => 'price', 'products_model' => 'model', 'final_price' => 'final_price'));

        $data_columns_products = $this->buildColumns($mapping);


        // Table mapping orders_total
        $mapping = array();

        $mapping[TABLE_ORDERS_TOTAL] = array(
            'alias' => 'ot',
            'fields' => array('text' => 'text', 'value' => 'value', 'title' => 'title'));

        $data_columns_totals = $this->buildColumns($mapping);


        $order_data = array();
        foreach ($result_orders as $order) {

            $order_data_row = $order;

            $sql_orders_products = "SELECT {$data_columns_products} 
            FROM " . TABLE_ORDERS_PRODUCTS . " op 
            WHERE op.orders_id = " . $order['order_id'];

            $result_orders_products = $this->_db($sql_orders_products);

            foreach ($result_orders_products as $key => $product) {
                $result_orders_products[$key]['price'] = mh_price($product['price'], 1, false);
                $result_orders_products[$key]['final_price'] = mh_price($product['final_price'], 1, false);
            }

            $products = $this->flatten($result_orders_products, 'product');
            $order_data_row = array_merge($order_data_row, $products[0]);


            $sql_orders_total = "SELECT {$data_columns_totals}
                    FROM " . TABLE_ORDERS_TOTAL . " ot
                    WHERE ot.orders_id = " . $order['order_id'] . " ORDER BY ot.sort_order ASC ";
            $result_orders_total = $this->_db($sql_orders_total);

            $totals = $this->flatten($result_orders_total, 'total');
            $order_data_row = array_merge($order_data_row, $totals[0]);

            $order_data[] = $order_data_row;
        }

        return $order_data;
    }
}
