<?php

require_once(MH_DIR_CONFIG . 'config_gdpr_export/classes/gdprbeez.php');


class gdpr_store_reviews extends gdprbeez
{

    public function __construct()
    {
        parent::__construct();
        $this->sort_order = 2;
        $this->code = 'reviews';
        $this->storedata = true;
        $this->title = mh_lng('MAILBEEZ_GDPR_REVIEWS_TITLE');
        $this->description = mh_lng('MAILBEEZ_GDPR_REVIEWS_DESCRIPTION');
    }

    public function readData()
    {

        // Table mapping
        $mapping = array();
        $mapping[TABLE_REVIEWS] = array(
            'alias' => 'r',
            'fields' => array('date_added' => 'date', 'reviews_rating' => 'rating', 'customers_name' => 'name'));
        $mapping[TABLE_REVIEWS_DESCRIPTION] = array(
            'alias' => 'rd',
            'fields' => array('reviews_text' => 'review'));
        $mapping[TABLE_PRODUCTS_DESCRIPTION] = array(
            'alias' => 'pd',
            'fields' => array('products_name' => 'product'));

        $data_columns = $this->buildColumns($mapping);




        $sql = "SELECT {$data_columns}
                    FROM " . TABLE_REVIEWS . " r
                    JOIN " . TABLE_REVIEWS_DESCRIPTION . " rd
                    ON r.reviews_id = rd.reviews_id
                    JOIN " . TABLE_PRODUCTS_DESCRIPTION . " pd
                    ON pd.products_id = r.products_id
                    WHERE customers_id =" . $this->getContactId() . "
                    AND pd.language_id = " . $_SESSION['languages_id'];

        $result_raw = $this->_db($sql);

        $result = array();
        $cnt = 1;
        foreach ($result_raw as $row) {
            $result['review-' . $cnt] = $this->mergeLine($row);
            $cnt++;
        }

        return array($result);

        return $result;
    }
}
