<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');

mh_define('MAILBEEZ_CONFIG_GOOGLEANALYTICS_STATUS', 'True');
mh_define('MAILBEEZ_MAILHIVE_GA_ENABLED_ICON', '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 2195.9 2430.9" style="enable-background:new 0 0 2195.9 2430.9;" xml:space="preserve">
<style type="text/css">
	.st0{fill:#F9AB00;}
	.st1{fill:#E37400;}
</style>
<g>
	<path class="st0" d="M2195.9,2126.7c0.9,166.9-133.7,302.8-300.5,303.7c-12.4,0.1-24.9-0.6-37.2-2.1
		c-154.8-22.9-268.2-157.6-264.4-314V316.1c-3.7-156.6,110-291.3,264.9-314c165.7-19.4,315.8,99.2,335.2,264.9
		c1.4,12.2,2.1,24.4,2,36.7L2195.9,2126.7z"/>
	<path class="st1" d="M301.1,1828.7c166.3,0,301.1,134.8,301.1,301.1c0,166.3-134.8,301.1-301.1,301.1
		C134.8,2430.9,0,2296.1,0,2129.8C0,1963.5,134.8,1828.7,301.1,1828.7z M1093.3,916.2c-167.1,9.2-296.7,149.3-292.8,316.6v808.7
		c0,219.5,96.6,352.7,238.1,381.1c163.3,33.1,322.4-72.4,355.5-235.7c4.1-20,6.1-40.3,6-60.7v-907.4
		c0.3-166.9-134.7-302.4-301.6-302.7C1096.8,916.1,1095,916.1,1093.3,916.2z"/>
</g>
</svg>
');

class config_googleanalytics extends configbeez
{

// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_googleanalytics';
        $this->module = 'config_googleanalytics'; // same as folder name
        $this->version = '2.0'; // float value
        $this->title = mh_lng('MAILBEEZ_CONFIG_GOOGLEANALYTICS_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_CONFIG_GOOGLEANALYTICS_TEXT_DESCRIPTION');
        $this->description_image = '../../common/images/icon_ga_64.png';
        $this->icon = '../../common/images/icon_ga.png';
        $this->removable = false; // can't be removed
        $this->stealth = true; // don't list as an installed module
        $this->display_as_submodule_of = 'config';
        $this->sort_order = 4.1;
        $this->enabled = mh_cfg('MAILBEEZ_MAILHIVE_GA_ENABLED') == 'True';
        $this->status_key = 'MAILBEEZ_CONFIG_GOOGLEANALYTICS_STATUS';

        $this->documentation_key = $this->module; // leave empty if no documentation available
        $this->documentation_root = 'https://www.mailbeez.com/documentation/configbeez/';

        $this->_blueprint();

    }

    function config_googleanalytics()
    {
        self::__construct();
    }

// class methods

    function getAudience()
    {
        return false;
    }

    function check()
    {
        return true;
    }

    function remove()
    {
        return false;
    }

    // installation methods

    function keys()
    {
        return array('MAILBEEZ_MAILHIVE_GA_ENABLED', 'MAILBEEZ_MAILHIVE_GA_REWRITE_MODE', 'MAILBEEZ_MAILHIVE_GA_REWRITE_FORMAT', 'MAILBEEZ_MAILHIVE_GA_MEDIUM', 'MAILBEEZ_MAILHIVE_GA_SOURCE',);
    }

    function install()
    {
        return false;
    }

}

