<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');

mh_define('MAILBEEZ_CONFIG_PROCESS_CONTROL_KILL_FOLDER', mh_cfg('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_COMPILE_DIR'));

class config_process_control extends configbeez
{
// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_process_control';
        $this->module = 'config_process_control'; // same as folder name
        $this->version = '2.2'; // float value
        $this->title = mh_lng('MAILBEEZ_CONFIG_PROCESS_CONTROL_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_CONFIG_PROCESS_CONTROL_TEXT_DESCRIPTION');
        $this->description_image = '../../common/images/icon_system_64.png';
        $this->icon = '../../common/images/icon_system.png';
        $this->removable = false; // can't be removed
        $this->stealth = true; // don't list as an installed module
        $this->display_as_submodule_of = 'config';
        $this->sort_order = 2;
        $this->enabled = mh_cfg('MAILBEEZ_MAILHIVE_PROCESS_CONTROL') == 'True';
        $this->enabled = true;
        $this->admin_action_plugins_path = MH_DIR_CONFIG; // default-path to include admin action plugins from
        $this->admin_action_plugins = ''; //'simulation_restart.php';
        $this->admin_action_plugins_path = MH_DIR_CONFIG; // default-path to include admin action plugins from
        $this->admin_action_plugins = 'kill_process.php';

        $this->documentation_key = 'config_process_control'; // leave empty if no documentation available
    }

    function config_process_control()
    {
        self::__construct();
    }

// class methods

    function getAudience()
    {
        return false;
    }

    function check()
    {
        return true;
    }

    function remove()
    {
        return false;
    }

    // installation methods

    function keys()
    {

        $keys = array(
//            'MAILBEEZ_MAILHIVE_PROCESS_CONTROL',
            'MAILBEEZ_MAILHIVE_PROCESS_CONTROL_LOCK_PERIOD', 'MAILBEEZ_MAILHIVE_PROCESS_CONTROL_MEMORY_LIMIT', 'MAILBEEZ_MAILHIVE_PROCESS_CONTROL_INGORE_USER_ABORT');

        if (!ini_get('safe_mode')) {
            $keys[] = 'MAILBEEZ_MAILHIVE_PROCESS_CONTROL_TIME_LIMIT';
        }

        return $keys;
    }

    function install()
    {
        return false;
    }

    static function set_kill()
    {
        // get latest entry
        $check_query_sql = "select batch_id, date_added
                                from " . TABLE_MAILBEEZ_PROCESS . "
                            order by lock_id desc limit 1,1";

        $check_query = mh_db_query($check_query_sql);

        if (mh_db_num_rows($check_query) > 0) {
            $check = mh_db_fetch_array($check_query);

            config_process_control::process_control_gc();
            // make kill file
            $kill_file_path = MAILBEEZ_CONFIG_PROCESS_CONTROL_KILL_FOLDER . 'kill_' . $check['batch_id'] . '.txt';

            if ($fp = @fopen($kill_file_path, 'w')) {
                flock($fp, 2); // LOCK_EX
                fputs($fp, $check['batch_id']);
                flock($fp, 3); // LOCK_UN
                fclose($fp);
            }
        }
    }

    static function check_kill($batch_id)
    {
        return file_exists(MAILBEEZ_CONFIG_PROCESS_CONTROL_KILL_FOLDER . 'kill_' . $batch_id . '.txt');
    }


    static function process_control_gc()
    {

        if ($dir = @opendir(MAILBEEZ_CONFIG_PROCESS_CONTROL_KILL_FOLDER)) {

            while ($kill_file = readdir($dir)) {
                if (preg_match('/^kill/', $kill_file)) {
                    @unlink(MAILBEEZ_CONFIG_PROCESS_CONTROL_KILL_FOLDER . $kill_file);
                }
            }
            closedir($dir);
        }

    }
}


