<?php
mh_define('MH_POPUP', true);
mh_define('MH_POP_EXCLUDE_SHOPCSS', true);
mh_define('MH_POP_INCLUDE_BOOTSTRAP', true);
mh_define('MH_POP_EXCLUDE_MAINSTYLE', true);

include_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/main/inc_design.php');

$query_table = "ALTER TABLE " . TABLE_MAILBEEZ_LANGUAGE_OBJECTS . "
                CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";

$query_column = "ALTER TABLE " . TABLE_MAILBEEZ_LANGUAGE_OBJECTS . "
            CHANGE language_objects_content language_objects_content
            LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";

$link = mh_href_link(mh_fn('FILENAME_MAILBEEZ'), 'app=load_app&app_path=configbeez/config_queen/admin_application_plugins/emoji_migration.php');
$runLink = $link .= '&action=run';

$action_processed = false;

if (mh_get('action') == 'run') {

    // Step 1: Upgrade table-wide charset if not yet utf8mb4
    $table_info = mh_db_query("SHOW TABLE STATUS LIKE '" . TABLE_MAILBEEZ_LANGUAGE_OBJECTS . "'");
    if ($table_info && $row = mh_db_fetch_array($table_info)) {
        if (stripos($row['Collation'], 'utf8mb4') === false) {
            mh_db_query($query_table);
        }
    }

    // Step 2: Upgrade specific column if needed
    $field_info = mh_get_field_info(TABLE_MAILBEEZ_LANGUAGE_OBJECTS, 'language_objects_content');

    $needs_type_change = (strtolower($field_info['Type']) !== 'longtext');
    $needs_charset_change = !empty($field_info['Collation']) && stripos($field_info['Collation'], 'utf8mb4') === false;

    if ($needs_type_change || $needs_charset_change) {
        mh_db_query($query_column);
    }
    $action_processed = true;
}


$check_data = mh_check_emoji_configuration();
$table_upgradable = mh_is_safe_to_upgrade_table_charset();

$emoji_supported = mh_arr_val($check_data, 'emoji_supported', false);

mh_update_config_value(['configuration_title' => mh_lng('MAILBEEZ_EMOJI_SUPPORT_TITLE'),
    'configuration_key' => 'MAILBEEZ_EMOJI_SUPPORT',
    'configuration_value' => $emoji_supported,
    'configuration_description' => mh_lng('MAILBEEZ_EMOJI_SUPPORT_DESC')
]);


?>
<div style="text-align: center; ">
    <h3><?php echo mh_lng('MAILBEEZ_EMOJI_MIGRATION_HEADLINE'); ?></h3>
    <br>
    <?php

    $allow_upgrade = mh_arr_val($table_upgradable, 'safe', false);

    if ($emoji_supported ) {
        ?>
        <div class="panel panel-primary " style="width: 100%; max-width: 600px; margin: 0 auto;">
            <div class="panel-heading">
                <h3 class="panel-title">
                    <?php echo mh_lng('MAILBEEZ_EMOJI_MIGRATION_ENABLED_TITLE'); ?>
                </h3>
            </div>
            <div class="panel-body">

                <br>
                <?php echo mh_lng('MAILBEEZ_EMOJI_MIGRATION_ENABLED_TEXT'); ?>
                <br>
                <br>
            </div>
        </div>
        <?php

    } elseif (!$emoji_supported && $allow_upgrade) {
        ?>
        <div class="panel panel-success " style="width: 100%; max-width: 600px; margin: 0 auto;">
            <div class="panel-heading">
                <h3 class="panel-title">
                    <?php echo mh_lng('MAILBEEZ_EMOJI_MIGRATION_SAFE_HEADLINE'); ?>
                </h3>
            </div>
            <div class="panel-body">
                <br>

                <a href="<?php echo $runLink; ?>" class="btn btn-primary">
                    <i class="fa fa-database" style="padding-right: 5px"></i>
                    <?php echo mh_lng('MAILBEEZ_EMOJI_MIGRATION_RUN_BUTTON'); ?>
                </a>

                <br>
                <br>
                <hr>


                <?php echo mh_lng('MAILBEEZ_EMOJI_MIGRATION_SQL_INTRO'); ?>
                <br>
                <br>
                <?php echo mh_lng('MAILBEEZ_EMOJI_MIGRATION_SQL_STEP1'); ?>
                <br>
                <br>
                <code><?php echo $query_table; ?></code>
                <br>
                <br>

                <?php echo mh_lng('MAILBEEZ_EMOJI_MIGRATION_SQL_STEP2'); ?>
                <br>
                <br>
                <code><?php echo $query_column; ?></code>
            </div>
        </div>

        <?php
    } elseif (!$emoji_supported && !$allow_upgrade) {
        ?>
        <div class="panel panel-danger " style="width: 100%; max-width: 600px; margin: 0 auto;">
            <div class="panel-heading">
                <h3 class="panel-title">
                    <?php echo mh_lng('MAILBEEZ_EMOJI_MIGRATION_UNSAFE_HEADLINE'); ?>
                </h3>
            </div>
            <div class="panel-body">
                <?php echo mh_arr_val($table_upgradable, 'reason', mh_lng('MAILBEEZ_EMOJI_MIGRATION_UNKNOWN_ERROR')); ?>
                <br>
                <br>
                <?php echo mh_arr_val($table_upgradable, 'recommendation', mh_lng('MAILBEEZ_EMOJI_MIGRATION_UNSAFE_CHECK')); ?>
                <br>
                <br>
                <?php echo mh_lng('MAILBEEZ_EMOJI_MIGRATION_UNSAFE_CHECK'); ?>
                <br>
                <br>
                <code><?php echo $query_table; ?></code>
                <br>
                <br>
            </div>
        </div>
        <?php
    }
    ?>




    <?php

    ?>
</div>