<?php
/**
 * Shop-Reviews
 *
 * @released under the GNU General Public License
 * inspired and in parts based on
 * Copyright (c) 2003 osCommerce
 * @author H-P Sausen
 * @copyright (c) since 2010 web4design.de
 * @contact webmaster@web4design.de
 * @version 3.0
 */

require_once('includes/application_top.php');

error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE & ~E_STRICT);
/*
ini_set('display_errors', 1);
*/
if (!defined('MH_DIR_FS_CATALOG')) {
    if (substr(DIR_FS_CATALOG, -1) != '/') {
        define('MH_DIR_FS_CATALOG', DIR_FS_CATALOG . '/');
    } else {
        define('MH_DIR_FS_CATALOG', DIR_FS_CATALOG);
    }
}

if (!defined('MH_ROOT_PATH')) {
    // default location
    $_MH_ROOT_PATH = 'mailhive/';
    $_mh_search_paths = array('mailhive/', 'ext/mailhive/', 'includes/external/mailhive/');

    foreach ($_mh_search_paths as $_MH_ROOT_PATH_TRY) {
        if (file_exists(MH_DIR_FS_CATALOG . $_MH_ROOT_PATH_TRY . 'cloudbeez/cloudloader_core.php')) {
            $_MH_ROOT_PATH = $_MH_ROOT_PATH_TRY;
            break;
        }
    }

    define('MH_ROOT_PATH', $_MH_ROOT_PATH);
}

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/compatibility.php');
require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailhive.php');

function load_classes($class_name) {
    $file = MH_DIR_CONFIG . 'config_shopvoting/classes/' . $class_name . '.php';
    if (!file_exists($file)) return false;
    require_once $file;
}
spl_autoload_register('load_classes');


mh_define('DIR_ADMIN', ''); // PHP7.2 compatibility - make sure constant is defined

$voting = new Shopvoting();

$smarty = new mh_Smarty;
$smarty->setTemplateDir($voting->template_path); // root dir to templates
$smarty->setCompileCheck(true);
$smarty->setCompileId('shopvoting');
$smarty->setConfigDir($voting->main_path . 'lang/');

$language = $_SESSION['language'];


if (file_exists($smarty->getConfigDir(0) . $language . '/shopreview.php')) {
    $smarty->assign('language', $language);
} else {
    $language = 'english';
    $smarty->assign('language', $language);
}


if(file_exists($voting->main_path . 'lang/' . $language . '/own_shopreview.php')) {
    require_once($voting->main_path . 'lang/' . $language . '/own_shopreview.php');
} else {
    require_once($voting->main_path . 'lang/' . $language . '/shopreview.php');
}

$own_lang_conf = 0;
if(file_exists($voting->main_path . 'lang/' . $language . '/own_shopreview.conf')) {
    $own_lang_conf = 1;
}


/**
 * check the group permission
 */
$readCheck = $voting->getGroupAccess($voting->customer_group_read, (int)$_SESSION['customers_status']['customers_status_id']);

// if ($readCheck != 1 || $voting->voting_module_aktive == 0) {
//   mh_redirect(mh_href_link(FILENAME_LOGIN, '', 'SSL'));
// }

//require (DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/source/boxes.php');


/*
 * old url parameter compatibility
 *
 */
 if( mh_get('anzeige') == 'positive') {
    mh_redirect(mh_href_link(FILENAME_WEB4DESIGN_DE_REVIEW_PAGE, 'display=positive', 'NONSSL'));
} elseif(mh_get('anzeige') == 'neutral') {
    mh_redirect(mh_href_link(FILENAME_WEB4DESIGN_DE_REVIEW_PAGE, 'display=neutral', 'NONSSL'));
} elseif(mh_get('anzeige') == 'negative') {
    mh_redirect(mh_href_link(FILENAME_WEB4DESIGN_DE_REVIEW_PAGE, 'display=negative', 'NONSSL'));
}


$page = mh_get('page');
$display = mh_get('display');
$review = mh_get('review');


/**
 * to thumb through the votes
 */

// todo
// compatibility with non xtc systems


if (MH_PLATFORM == 'xtc' || MH_PLATFORM == 'gambio') {
    $vote_split = new splitPageResults($voting->getReviewSQL(true, $display), (int)$page, $voting->entry_per_page_frontend);
} else {
    $vote_split = new splitPageResults($voting->getReviewSQL(true, $display), $voting->entry_per_page_frontend);
}



/**
 * count the different votes
 */
$count_all_positiv = $voting->getCountSingleVotes(Shopvoting::POSITIV_RATES, Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING);
$count_all_neutral = $voting->getCountSingleVotes(Shopvoting::NEUTRAL_RATES, Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING);
$count_all_negative = $voting->getCountSingleVotes(Shopvoting::NEGATIVE_RATES, Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING);

/**
 * get the average
 */
$average_all = $voting->getAverage(Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING);
$average_site = $voting->getAverage(Shopvoting::COLUMN_WEB4DESIGN_DE_PAGE);
$average_shipping = $voting->getAverage(Shopvoting::COLUMN_WEB4DESIGN_DE_DELIVERY);
$average_service = $voting->getAverage(Shopvoting::COLUMN_WEB4DESIGN_DE_SERVICE);
$average_products = $voting->getAverage(Shopvoting::COLUMN_WEB4DESIGN_DE_PRODUCTS);

/**
 * necessary to set the css class for: show all
 */
if (strlen($display) < 7 || $display == '') {
    $display = 'all';
}

/**
 * set the pagepart info
 */
$pagepart = $voting->pagepart();


/**
 * assign a lot of smarty
 */
$smarty->assign('SHOPREVIEWS_POSITIVE', $count_all_positiv);
$smarty->assign('SHOPREVIEWS_NEUTRAL', $count_all_neutral);
$smarty->assign('SHOPREVIEWS_NEGATIVE', $count_all_negative);

$smarty->assign('SHOPREVIEWS_ALL', $voting->getCountDetailVotes(Shopvoting::COLUMN_WEB4DESIGN_DE_SHOPRATING));
$smarty->assign('SHOPREVIEWS_ALL_PAGE', $voting->getCountDetailVotes(Shopvoting::COLUMN_WEB4DESIGN_DE_PAGE));
$smarty->assign('SHOPREVIEWS_ALL_DELIVERY', $voting->getCountDetailVotes(Shopvoting::COLUMN_WEB4DESIGN_DE_DELIVERY));
$smarty->assign('SHOPREVIEWS_ALL_SERVICE', $voting->getCountDetailVotes(Shopvoting::COLUMN_WEB4DESIGN_DE_SERVICE));
$smarty->assign('SHOPREVIEWS_ALL_PRODUCTS', $voting->getCountDetailVotes(Shopvoting::COLUMN_WEB4DESIGN_DE_PRODUCTS));


$smarty->assign('RATING_POSITIVE_PERCENT', $voting->getPercentage($count_all_positiv));
$smarty->assign('RATING_NEUTRAL_PERCENT', $voting->getPercentage($count_all_neutral));
$smarty->assign('RATING_NEGATIVE_PERCENT', $voting->getPercentage($count_all_negative));

$smarty->assign('SHOPREVIEWS_ALL_AVERAGE', $average_all);
$smarty->assign('SHOPREVIEWS_PAGE', $average_site);
$smarty->assign('SHOPREVIEWS_DELIVERY', $average_shipping);
$smarty->assign('SHOPREVIEWS_SERVICE', $average_service);
$smarty->assign('SHOPREVIEWS_PRODUCTS', $average_products);

$smarty->assign('ALL_STARS', $voting->getStar($average_all));
$smarty->assign('PAGE_STARS', $voting->getStar($average_site));
$smarty->assign('DELIVERY_STARS', $voting->getStar($average_shipping));
$smarty->assign('SERVICE_STARS', $voting->getStar($average_service));
$smarty->assign('PRODUCTS_STARS', $voting->getStar($average_products));

$smarty->assign('RATING_TEXT', $voting->getVotingText($average_all));

$smarty->assign('ACTIVE_CLASS', $display);
$smarty->assign('LINK_ALLE', mh_href_link(FILENAME_WEB4DESIGN_DE_REVIEW_PAGE, '', 'NONSSL'));
$smarty->assign('LINK_POSITIV', mh_href_link(FILENAME_WEB4DESIGN_DE_REVIEW_PAGE, 'display=positive', 'NONSSL'));
$smarty->assign('LINK_NEUTRAL', mh_href_link(FILENAME_WEB4DESIGN_DE_REVIEW_PAGE, 'display=neutral', 'NONSSL'));
$smarty->assign('LINK_NEGATIV', mh_href_link(FILENAME_WEB4DESIGN_DE_REVIEW_PAGE, 'display=negative', 'NONSSL'));


$nav_mod2 = 0;

if ($vote_split->number_of_rows > 0) {
    if(MH_PLATFORM == 'zencart') {
        $navbar = $vote_split->display_links(mh_cfg('MAX_DISPLAY_PAGE_LINKS'), mh_get_all_get_params(array('page', 'info', 'x', 'y')));
        // BOF ZenExpert - fix pagination - error caused by SEO URLs
        //$navbar = str_replace('index.php?main_page=index',FILENAME_WEB4DESIGN_DE_REVIEW_PAGE . '?zen=n',$navbar);
        $navbar = str_replace(zen_href_link(FILENAME_DEFAULT),FILENAME_WEB4DESIGN_DE_REVIEW_PAGE, $navbar);
        $navbar = str_replace('phpindex','php', $navbar);
        $navbar = str_replace('index.html','',$navbar);
        $navbar = str_replace('.php&amp;','.php?',$navbar);
        $navbar = str_replace('.php&','.php?',$navbar);
    } else {

        if (file_exists(DIR_FS_CATALOG.DIR_ADMIN.'includes/version.php')) {
            require_once(DIR_FS_CATALOG.DIR_ADMIN.'includes/version.php');
        }

        $navbar = $vote_split->display_links(mh_cfg('MAX_DISPLAY_PAGE_LINKS'), mh_get_all_get_params(array('page', 'info', 'x', 'y')));

        if ((mh_cfg('USE_PAGINATION_LIST') == 'true' && mh_cfg('MH_PLATFORM') == 'xtc') || mh_cfg('PROJECT_MAJOR_VERSION') == 2) {
            $nav_mod2 = 1;
        }
    }
    $smarty->assign('NAVBAR', $navbar);
}

$smarty->assign('NAVBAR_MOD2', $nav_mod2);


if ($review  == 'ok') {
    if ($voting->activate_votings == 0) {
        $smarty->assign('REVIEW_OK', 'ok');
    } else {
        $smarty->assign('REVIEW_OK', 'free');
    }
}

$smarty->assign('module_content', $voting->getReviewVotes((int)$page, $vote_split));
$smarty->assign('OPINION_LINK', mh_href_link(FILENAME_WEB4DESIGN_DE_REVIEW_WRITE, '', 'NONSSL'));
$smarty->assign('OPINION_IMAGE', $voting->module_path_url . 'templates/buttons/' . $language . '/button_vote.png');


if (MH_REQUEST_TYPE == 'NONSSL' && strpos($voting->logo_url,'https://') === 0) {
    $voting->logo_url = str_replace('https://', 'http://',$voting->logo_url);
}

$smarty->assign('IMG_PATH_LOGO_URL',  $voting->logo_url);
$smarty->assign('HOME', mh_href_email_link(FILENAME_DEFAULT));

$smarty->assign('languageconf', $language);
$smarty->assign('language', $language);
$smarty->assign('languageCode', $_SESSION['language_code']);
$smarty->assign('tplPath', $voting->template_path);
$smarty->assign('modulePathUrl', $voting->module_path_url);
$smarty->assign('CANONICAL', $PHP_SELF);
$smarty->assign('ABOUT_US', $voting->getAboutUsContent());


$checkSSL = '';

if ($request_type == 'SSL') {
    $checkSSL = HTTPS_SERVER . DIR_WS_CATALOG;
} else {
    $checkSSL = HTTP_SERVER . DIR_WS_CATALOG;
}

$smarty->assign('BASE', $checkSSL);
$smarty->assign('CHARSET', $_SESSION['language_charset']);
$smarty->assign('NO_OP', '0');
$smarty->assign('TITLE', $voting->title);
$smarty->assign('META_DESCRIPTION', $voting->meta_description);
$smarty->assign('META_KEYWORDS', $voting->meta_keywords);
$smarty->assign('AUTHOR', $voting->snippet_author);
$smarty->assign('ITEMPROP_NAME', $voting->itemprop_name);
$smarty->assign('LANGUAGES', $voting->getLanguagesBox(FILENAME_WEB4DESIGN_DE_REVIEW_PAGE));


$smarty->assign('SHOW_RICH_SNIPPET', $voting->template_box_show_snippets);
$smarty->assign('SNIPPING_TYPE_NAME', $voting->snippet_type_name);


$smarty->assign('OWN_LANG_CONF', $own_lang_conf);

$template_style_select_path = $voting->template_style_path . $voting->template_style . '/';
$template_style_css_path = $voting->template_style_css_path . $voting->template_style . '/';

$check_individual_style = $voting->checkAllSelectedTstyleFilesExists();

if($check_individual_style == 0) {
    $template_style_select_path = $voting->template_style_path . Shopvoting::SHOPVOTING_DEFAULT_TEMPLATE . '/';
    $template_style_css_path = $voting->template_style_css_path . Shopvoting::SHOPVOTING_DEFAULT_TEMPLATE . '/';
}


$smarty->assign('HEADER', $template_style_select_path . 'header.html');
$smarty->assign('SNIPPET_CODE', $template_style_select_path . 'snippet_code.html');
$smarty->assign('STYLESHEET_PATH', $template_style_css_path . 'stylesheet.css?v=' . mh_cfg('MAILBEEZ_VERSION'));
$smarty->assign('STYLESHEET_BOX_PATH', $template_style_css_path . 'stylesheetbox.css?v=' . mh_cfg('MAILBEEZ_VERSION'));
$smarty->assign('LEFTSIDEINFO', $template_style_select_path . 'leftsideinfo.html');
$smarty->display($template_style_select_path . 'shop-review.html');



$voting->modulesout();

if(!$voting->routput){$voting->setoutput();}
mh_exit();
