<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/viewbeez.php');
require_once(MH_DIR_CONFIG . 'config_shopvoting.php');

if (!class_exists('Shopvoting')) {
    require_once(MH_DIR_CONFIG . 'config_shopvoting/classes/Shopvoting.php');
}


class view_shopvoting extends viewbeez
{




    function __construct()
    {
        parent::__construct();

        $this->code = 'view_shopvoting';
        $this->module = 'view_shopvoting';
        $this->version = '1.0';
        $this->title = mh_lng('MAILBEEZ_VIEW_SHOPVOTING_TITLE');
        $this->description = mh_lng('MAILBEEZ_VIEW_SHOPVOTING_DESCRIPTION');

        $this->sort_order = 300;
        $this->enabled = mh_cfg('MAILBEEZ_SHOPVOTING_STATUS') == 'True';
        $this->set_template();
        $this->has_dashboard_view = true;

        $this->hidden = !$this->enabled;
        $this->viewpage = mh_get('view_page', 'overview');


        $this->admin_link = mh_href_link(mh_fn('FILENAME_MAILBEEZ'), 'app=load_app&app_path=config_shopvoting/admin_application_plugins/manage.php&module=config_shopvoting&w4d_popup=1');

        $this->app_cache_time = 15*60;
        $this->panel_ajax_refresh = true;

    }

    function view_shopvoting()
    {
        self::__construct();
    }

    function set_context($context)
    {
        if ($context == 'panel') {
            $this->sort_order = 3;
        }
    }


    function get_view_content($template)
    {
        $smarty = $this->init_view_content($template);

        $shopvoting_array = $this->read_shopvotings($this->customer->id);

        $smarty->assign('ratings', $shopvoting_array);

        return $this->parse_view_content($smarty, $template);
    }


    function get_view_summary()
    {
        return false;

        $smarty = $this->init_view_summary();

        // implement logic to get data
        // assign to smarty template variables

        // $smarty->assign(array('shopvoting' => $shopvoting_data_array));
        // $smarty->assign('name' => $name);

        return $this->parse_view_summary($smarty);
    }


    function get_view_dashboard_widget()
    {
        return false;

        $smarty = $this->init_view_dashboard_widget('shopvoting');

        return $this->parse_view_dashboard_widget($smarty);

    }


    function get_view_dashboard_content($template)
    {
        $smarty = $this->init_view_dashboard('shopvoting');
        $smarty->assign(array('view_page' => $this->viewpage));

        $shopvoting_array = $this->read_shopvotings();

        $smarty->assign('ratings', $shopvoting_array);
        $smarty->assign(array('returnpage' => base64_encode($this->get_menu_link('dashboard'))));

        return $this->parse_view_dashboard($smarty);
    }


    // todo
    function cnt_shopvoting()
    {
        if ($this->customer->id != 0) {
            return false;
        } else {
            return false;
        }
    }


    public function data_update()
    {

        $this->set_cache_id('global', 'num_of_shopvotings');
        $this->purge_cache('app');
        $this->set_cache_id('mailbeez_shopvoting', 'crm_panel');
        $this->purge_cache('app');
        $this->notficationsObj = new notificationbeez();

        $shopvoting_array = $this->read_shopvotings('', 3);

        foreach ($shopvoting_array as $shopvoting) {

            $notification = array('title' => mh_cfg('MAILBEEZ_SHOPVOTING_NOTIFICATION_NEW'),
                'notification_summary' => $shopvoting['shopreviews_shoprating'] . ' - ' . $shopvoting['shopreviews_text'],
                'notification' => $shopvoting['shopreviews_shoprating'] . ' - ' . $shopvoting['shopreviews_text'],
                'module' => $this->code,
                'ref_id' => $shopvoting['shopreviews_id'],
                'iteration' => 1,
                'customers_id' => null,
                'severity' => 5,
                'link' => $this->admin_link,
                'link_type' => 'P', // E - external, I - internal, P - popup
                'panel_click_action' => 'H', // H - hide
                'channel_id' => 0,
                'status' => '0',
                'icon_style' => 'background-image: url(' . mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'configbeez/config_shopvoting/viewbeez/view_shopvoting/icon_panel.png); background-color: #c4e1fd');
            $this->notficationsObj->add($notification);

        }
    }

    function get_view_panel()
    {

        $this->set_cache_id('mailbeez_shopvoting', 'crm_panel');

        if ($cache = $this->read_cache('app')) {
            return $cache['value'];
        }

        $voting = new Shopvoting();
        $voting->show_all_languages = 1;

        $language = $_SESSION['language'];

        // lngrefactor


        if (file_exists($voting->main_path . '/lang/' . $language . '/shopreview.php')) {
        } else {
            $language = 'english';
        }
        require_once($voting->main_path . '/lang/' . $language . '/shopreview.php');

        $voting_text = $voting->getVotingText();
        $voting_average = $voting->getAverage("shopreviews_shoprating");

        $smarty = $this->init_view_panel($this->module);

        $smarty->assign(array('voting_text' => $voting_text,
            'voting_average' => $voting_average,
            'admin_link' => $this->admin_link));

        $content = $this->parse_view_panel($smarty);

        return $this->set_cache($content, 'app');

    }


    function read_shopvotings($customers_id = '', $timerange = '')
    {
        $voting = new Shopvoting();
        $voting->show_all_languages = 1;


        $language = $_SESSION['language'];
        if (file_exists($voting->main_path . '/lang/' . $language . '/shopreview.php')) {
        } else {
            $language = 'english';
        }
        require_once($voting->main_path . '/lang/' . $language . '/shopreview.php');

        // look 3 days back for new votes
        $shopvotings_query_sql = $voting->getReviewSQL(false, '', $timerange, $customers_id);
        $shopvotings_query = mh_db_query($shopvotings_query_sql);
        $result = array();

        while ($shopvoting = mh_db_fetch_array($shopvotings_query)) {
            $result[] = $shopvoting;
        }

        return $result;
    }
}
