<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011, 2012 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');

class config_sitezen extends configbeez
{
// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_sitezen';
        $this->module = 'config_sitezen'; // same as folder name
        $this->version = '1.6'; // float value
        $this->title = mh_lng('MAILBEEZ_CONFIG_SITEZEN_TEXT_TITLE', 'SiteZen Connector');
        $this->description = mh_lng('MAILBEEZ_CONFIG_SITEZEN_TEXT_DESCRIPTION', 'Connects your Shop with SiteZen');
//        $this->description_image = '../../common/images/icon_ma_64.png';
//        $this->icon = '../../common/images/icon_ma.png';
        $this->removable = false; // can't be removed
        $this->stealth = true; // don't list as an installed module
        $this->display_as_submodule_of = 'config';
        $this->sort_order = 9;
        $this->enabled = mh_cfg('MAILBEEZ_MAILHIVE_STATUS') == 'True';

        $this->documentation_key = 'config_sitezen'; // leave empty if no documentation available

        $this->autoinstall();
        $this->_blueprint();
    }


// class methods

    function getAudience()
    {
        return false;
    }

    function check()
    {
        return true;
    }

    function remove()
    {
        return false;
    }

    // installation methods

    function keys()
    {
        $keys_array = array('MAILBEEZ_CONFIG_SITEZEN_TOKEN');
        return $keys_array;
    }


    function install()
    {
        mh_insert_config_value(array('configuration_title' => 'SiteZen token',
            'configuration_key' => 'MAILBEEZ_CONFIG_SITEZEN_TOKEN',
            'configuration_value' => '',
            'configuration_description' => 'Enter your SiteZen token'
        ));
    }

    function onSave()
    {
        if (file_exists(MH_DIR_CONFIG . 'config_sitezen/.sitezen.env')) {
            unlink(MH_DIR_CONFIG . 'config_sitezen/.sitezen.env');
        }

        self::generateEnvFile();
    }


    static function generateEnvFile()
    {
        $post_token = mh_post('configuration->MAILBEEZ_CONFIG_SITEZEN_TOKEN');

        if ($post_token) {
            $token = $post_token;
        } else {
            $token = mh_cfg('MAILBEEZ_CONFIG_SITEZEN_TOKEN', null);
        }

        if (is_null($token)) {
            return;
        }

        require_once(MH_DIR_CONFIG . 'config_sitezen/sitezen/Bootstrap/env.php');

        $env_file = MH_DIR_CONFIG . 'config_sitezen/.sitezen.env.php';

        $data = [
            'SITEZEN_TOKEN' => $token,
            'PLATFORM' => mh_cfg('MH_PLATFORM'),
            'DB_HOST' => mh_cfg('DB_SERVER'),
            'DB_USER' => mh_cfg('DB_SERVER_USERNAME'),
            'DB_PASS' => mh_cfg('DB_SERVER_PASSWORD'),
            'DB_NAME' => mh_cfg('DB_DATABASE'),
            'DB_PORT' => mh_cfg('DB_PORT'),
            'DB_SOCKET' => mh_cfg('DB_SOCKET'),
        ];

        \SiteZen\Telemetry\Bootstrap\Env::saveEnvFile($env_file, $data);
    }


}
