<?php

namespace SiteZen\Telemetry\Bootstrap;

class Data
{
    var $data;

    public function __construct($data, $processTime)
    {
        $returnArray = $data;
        $returnArray['_request'] = $processTime;
        $this->data = $returnArray;
    }

    public function __toString()
    {
        try {
            return json_encode(
                $this->data,
                JSON_UNESCAPED_UNICODE
                | JSON_INVALID_UTF8_SUBSTITUTE
                | JSON_PRESERVE_ZERO_FRACTION
                | JSON_THROW_ON_ERROR
            );
        } catch (\JsonException $e) {
            return 'json_encode failed: '.$e->getMessage();
        }
    }

    public function output()
    {
        header('Content-Type: application/json');
        echo $this->__toString(); // explicitly call __toString()
    }

}
