<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011, 2012 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');

mh_define('TABLE_MAILBEEZ_MODULE_CONFIGURATION', DB_PREFIX . 'mailbeez_module_configuration');

mh_load_modules_language_files(MH_DIR_CONFIG, 'config_tour');

class config_tour extends configbeez
{
// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_tour';
        $this->module = 'config_tour'; // same as folder name
        $this->version = 4.1; // float value
        $this->title = mh_lng('MAILBEEZ_CONFIG_TOUR_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_CONFIG_TOUR_TEXT_DESCRIPTION');
        $this->icon = 'icon.png';
        $this->description_image = 'icon_64.png';

//        $this->removable = false; // can't be removed
        $this->stealth = true; // don't list as an installed module
        $this->display_as_submodule_of = 'config';
        $this->sort_order = 4;
        $this->enabled = mh_cfg('MAILBEEZ_TOUR_STATUS') == 'True';
        $this->status_key = 'MAILBEEZ_TOUR_STATUS';
//$this->hidden = true;
        $this->on_cfg_save_clear_template_c = true;

        if (mh_cfg('MAILBEEZ_TOUR_STATUS') == 'False') {
            $this->admin_action_plugins = 'overview.php';
            $this->admin_action_plugins_path = mh_cfg('MH_DIR_CONFIG');
        }

        $this->documentation_key = 'config_tour'; // leave empty if no documentation available

        // self installing
        if (!mh_cfg($this->status_key)) {
//            $this->install();
        } else {
            $this->check_update();
        }

    }

    function config_tour()
    {
        self::__construct();
    }

// class methods

    function getAudience()
    {
        return false;
    }


    // installation methods

    function keys()
    {
        $keys_array = array('MAILBEEZ_TOUR_STATUS');
//        if (mh_get_conf('MAILBEEZ_TOUR_STATUS') == 'True') {
//            $keys_array = array('MAILBEEZ_TOUR_STATUS', 'MAILBEEZ_TOUR_MODE');
//        }
        return $keys_array;
    }

    function install()
    {
        mh_insert_config_value(array('configuration_title' => 'Activate Tour Modules',
            'configuration_key' => 'MAILBEEZ_TOUR_STATUS',
            'configuration_value' => 'True',
            'configuration_description' => 'Activate and configure this Module',
            'set_function' => 'mh_cfg_select_option(array(\'True\', \'False\'), '
        ));
        mh_insert_config_value(array('configuration_title' => 'Mode',
            'configuration_key' => 'MAILBEEZ_TOUR_MODE',
            'configuration_value' => 'Page',
            'configuration_description' => 'Show as Pop-up or as page',
            'set_function' => 'mh_cfg_select_option(array(\'Popup\', \'Page\'), '
        ));

        mh_db_query("CREATE TABLE IF NOT EXISTS " . DB_PREFIX . "mailbeez_module_configuration (
                        cfg_id int(11) NOT NULL auto_increment,
                        cfg_key varchar(255) default NULL,
                        cfg_value text default NULL,
                        last_modified datetime default NULL,
                        date_added datetime NOT NULL default '1000-01-01 00:00:00',
                        PRIMARY KEY  (cfg_id),
                        INDEX ( cfg_key ) );"
        );
    }
}
