<?php
/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez
*/
global $MAILBEEZ_HEADER;


$app_module_id = 'config_tour';
$app_path_module = 'configbeez/'  .$app_module_id;

include_once(MH_DIR_CONFIG . 'config_tour.php');
require_once(MH_DIR_CONFIG . $app_module_id . '/functions/general.php');


$MAILBEEZ_TABS = mh_tabs(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/admin_application_plugins/tabs.php', 'tour');

if (mh_cfg('MAILBEEZ_TOUR_MODE') == 'Popup') {
    mh_define('MH_POPUP', true);
}

$app_url = mh_href_link(FILENAME_MAILBEEZ, 'app=load_app&app_path=config_tour/admin_application_plugins/overview.php&' . mh_get_all_get_params(array('app', 'app_path', 'app_action', 'x', 'y')));


$action_main_url = $app_url;
$app_url_start = $app_url . '&app_action=start&tour_module=';
$app_url_stop = $app_url . '&app_action=stop&tour_module=';
$app_url_js_action = $app_url . '&app_action_js=';

$back_url = mh_href_link(FILENAME_MAILBEEZ, 'module=config_tour');

$app_action = mh_get('app_action', '');
$tour_module = mh_get('tour_module', '');
$is_ajax = mh_get('ajax', '');
$msg = '';
$msg_type = '';

list($tour_data, $tour_modules, $active_tours) = mh_tour();
if (!$active_tours) {
    unset($_SESSION['mh_tour_action']);
    unset($_SESSION['mh_active_tour']);
}

$tour_level = array('basic', 'advanced', 'module');

switch ($app_action) {
    case 'start':

        // stop all active tours
        unset($_SESSION['mh_active_tour']);
        unset($_SESSION['mh_tour_cnt']);
        unset($_SESSION['mh_tour_action']);

        if ($active_tours) {
            foreach ($active_tours as $active_tour) {
                $GLOBALS[$active_tour]->stop();
            }
        }

        if (is_object($GLOBALS[$tour_module])) {
            $tour_module_obj = $GLOBALS[$tour_module];
            $tour_module_obj->start();
            $_SESSION['mh_active_tour'] = $tour_module;
            $_SESSION['mh_tour_action'] = 'run';
        }
        if ($is_ajax) {
            echo 'OK';
            mh_exit();
        }

        mh_redirect($action_main_url);
        break;
    case 'stop':
        if ($active_tours) {
            foreach ($active_tours as $active_tour) {
                $GLOBALS[$active_tour]->stop();
            }
        }
        if ($is_ajax) {
            echo 'OK';
            mh_exit();
        }
        break;
    case 'end':
        unset($_SESSION['mh_tour_action']);
        unset($_SESSION['mh_active_tour']);
        unset($_SESSION['mh_tour_cnt']);

        if (is_object($GLOBALS[$tour_module])) {
            $tour_module_obj = $GLOBALS[$tour_module];
            $tour_module_obj->end();

        }
        if ($is_ajax) {
            echo 'OK';
            mh_exit();
        }
        mh_redirect($action_main_url);

        break;

}

?>
    <link rel="stylesheet" type="text/css" media="print, projection, screen"
          href="<?php echo mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH'); ?>configbeez/config_tour/css/main.css">

<?php
if (mh_cfg('MAILBEEZ_TOUR_MODE') != 'Popup') {
    echo $MAILBEEZ_TABS;
    // back
//    echo mb_admin_button($back_url, mh_lng('MH_BUTTON_BACK'), '', 'link') . '<br /><br />';
}
?>
    <style type="text/css">
        .mh_tour, .mh_tour > a {
            /*position: relative;*/
            font-family: Trebuchet MS, Arial !important;
            font-size: 13px;
        }

        .mh_tour {
            padding-left: 10px;
            padding-right: 10px;
            width: 75%;
        }

        .mh_tour h1 {
            font-size: 18px;
            padding-top: 20px;
            padding-bottom: 5px;
            margin: 0px;
        }

        .mh_tour h2 {
            font-size: 16px;
            padding-top: 15px;
        }

        .mh_tour .mh_tour_progress {
            float: right;
            font-weight: normal;
            font-size: 12px;
            display: inline-block;
            line-height: 21px;
        }

        .mh_tour ul {
            padding-left: 0px;
        }

        .mh_tour ul li {
            border: 1px solid rgba(0, 0, 0, 0.75);
            list-style-type: none;
            padding: 10px;
            margin-top: -1px;
            position: relative;
            border-left: 0px;

            border-right: 0px;
            padding-top: 10px;
            padding-bottom: 10px;
        }

        .mh_tour ul li:hover {
            background-color: rgba(128, 128, 128, 0.15) !important;
        }

        .mh_tour .mh_tour_description {
            float: left;
            display: block;
        }

        .mh_tour .mh_tour_title, .mh_tour .mh_tour_cnt {
            float: left;
            display: block;
            /*font-weight: bold !important;*/
            font-size: 13px;
        }

        .mh_tour .mh_tour_cnt {
            width: 30px;
        }

        .mh_tour ul li.mh_tour_ended {
            background-color: <?php echo mh_cfg('MH_COLOR_GREEN')?>;
            border-color: <?php echo mh_cfg('MH_COLOR_DARKGREEN')?>;
            color: rgba(0, 0, 0, 1.0);
            opacity: 0.5;
        }

        .mh_tour ul li.mh_tour_started {
            background-color: <?php echo mh_cfg('MH_COLOR_ORANGE')?>;
            border-color: <?php echo mh_cfg('MH_COLOR_DARKORANGE')?>;

            color: rgba(0, 0, 0, 0.75);
        }

        .mh_tour ul li.mh_tour_stopped {
            background-color: <?php echo mh_cfg('MH_COLOR_YELLOW')?>;
            border-color: <?php echo mh_cfg('MH_COLOR_DARKYELLOW')?>;
            color: rgba(0, 0, 0, 0.75);
        }

        .mh_tour ul li.mh_tour_new {
            /*border-color: red;*/
        }

        .mh_tour_ctrl_start, .mh_tour_ctrl_stop, .mh_tour_ctrl_restart {
            float: right;
            width: 60px;
            top: 0px;
            position: relative;
            text-align: right;
            z-index: 100;
            margin-top: -2px;
            padding-right: 10px;
            display: inline-block;
        }

        img.mh_tour_icon {
            width: 18px;
            height: 18px;
        }

        .mh_tour .mh_tour_row {
            display: table;
            position: relative;
        }

    </style>
    <div class="mh_tour">

        <h1><?php echo mh_lng('MAILBEEZ_CONFIG_TOUR_TEXT_TITLE'); ?></h1>
        <?php echo mh_lng('MAILBEEZ_CONFIG_TOUR_TEXT_DESCRIPTION'); ?>
        <ul>
            <?php
            foreach ($tour_level as $level) {
                $tour_cnt = 0;
                $tour_cnt_done = 0;

                foreach ($tour_data as $tour) {
                    if ($tour->level != $level) {
                        continue;
                    }
                    $tour_cnt++;
                    if ($tour->status['status'] == 'ended') {
                        $tour_cnt_done++;

                    }
                }

                if ($tour_cnt == 0) {
                    continue;
                }

                ?>
                <h2> <?php echo mh_lng('MAILBEEZ_CONFIG_TOUR_SECTION_' . strtoupper($level)); ?>
                    <div class="mh_tour_progress">
                        <?php echo sprintf(MAILBEEZ_CONFIG_TOUR_PROGRESS, $tour_cnt_done, $tour_cnt) ?>
                    </div>
                </h2>
                <?php
                $tour_cnt = 0;
                foreach ($tour_data as $tour) {
                    if ($tour->level != $level) {
                        continue;
                    }
                    $tour_cnt++;

                    if ($tour->precondition_check) {

                        ?>
                        <li class="mh_tour_<?php echo $tour->status['status']; ?>"
                            <?php if ($tour->status['status'] == 'started') {

                                if (!isset($_SESSION['mh_active_tour'])) {
                                    $_SESSION['mh_active_tour'] = $tour->module;
                                }

                                $active_tour_obj = $GLOBALS[$_SESSION['mh_active_tour']];

                                if (is_object($active_tour_obj)) {


                                    ?>
                                    onclick="hopscotch.endTour(true);doAjaxGet('<?php echo $active_tour_obj->getAjaxEntrypoint('stop'); ?>');
                                        setTimeout(function(){document.location.href='<?php echo $action_main_url; ?>'},500);
                                        "
                                <?php }
                            } else { ?>
                                onclick="document.location.href='<?php
                                if ($tour->status['status'] == 'ended') {
                                    echo $app_url_start . $tour->module;
                                } else {
                                    echo $app_url_start . $tour->module;
                                }
                                ?>'"
                            <?php } ?>

                            >
                            <div class="mh_tour_status">
                                <!--
                        <?php //echo $tour->status['status']; ?>
-->

                            </div>
                            <?php
                            if ($tour->status['status'] == 'ended') {
                                ?>
                                <div class="mh_tour_ctrl_start">
                                    <img
                                        src="<?php echo mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH'); ?>configbeez/config_tour/images/UI_41.png"
                                        class="mh_tour_icon">
                                    <img
                                        src="<?php echo mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH'); ?>configbeez/config_tour/images/UI_173.png"
                                        class="mh_tour_icon">
                                </div>

                                <?php
                            } elseif ($tour->status['status'] == 'started') {
                                ?>
                                <div class="mh_tour_ctrl_stop"><img
                                        src="<?php echo mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH'); ?>configbeez/config_tour/images/UI_78.png"
                                        class="mh_tour_icon"></div>
                                <?php
                            } else {
                                ?>

                                <div class="mh_tour_ctrl_start"><img
                                        src="<?php echo mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH'); ?>configbeez/config_tour/images/UI_37.png"
                                        class="mh_tour_icon"></div>
                                <?php
                            }
                            ?>


                            <div class="mh_tour_row">
                                <div class="mh_tour_cnt">
                                    <?php echo $tour_cnt; ?>.
                                </div>
                                <div class="mh_tour_title">
                                    <?php if ($tour->pro) { ?>PRO <?php }?>
                                    <?php echo $tour->title; ?>
                                </div>
                                <div style="clear: both"></div>
                            </div>
                            <!--
                    <div class="mh_tour_row">
                        <div class="mh_tour_cnt">&nbsp;</div>
                        <div class="mh_tour_description">
                            <?php echo $tour->description; ?>
                        </div>
                        <div style="clear: both"></div>
                    </div>
-->
                        </li>
                        <?php
                    } else {
                        ?>
                        <li class="mh_tour_">

                            <div class="mh_tour_row">
                                <div class="mh_tour_cnt">
                                    <?php echo $tour_cnt; ?>.
                                </div>
                                <div class="mh_tour_title">
                                    <?php echo $tour->title; ?>
                                </div>
                                <div style="clear: both"></div>
                            </div>

                            <?php if ($tour->precondition_false_action) { ?>

                                <div class="mh_tour_row">
                                    <div class="mh_tour_cnt">&nbsp;</div>
                                    <div class="mh_tour_description"><b>

                                            <?php echo $tour->precondition_false_message; ?> |
                                            <a style="font-size: inherit; text-decoration: underline"
                                               href="<?php echo $tour->precondition_false_action['url']; ?>"
                                               <?php if ($tour->precondition_false_action['target']) {
                                               ?>target="<?php echo $tour->precondition_false_action['target']; ?>"<?php
                                            }
                                            ?>
                                                ><?php echo $tour->precondition_false_action['text']; ?></a>
                                        </b>

                                    </div>
                                    <div style="clear: both"></div>
                                </div>
                            <?php } ?>
                        </li>

                        <?php
                    }
                }
                if ($tour_cnt == 0) {
                    // no tour in this section
                    ?>
                    no tour yet
                    <?php
                }
                ?>
                <?php
            }
            ?>
        </ul>

        <a href="<?php echo mh_href_link(mh_fn('FILENAME_MAILBEEZ'), 'app=load_app&app_path=config_tour/admin_application_plugins/disable.php') ?>">
            <?php echo mh_lng('MAILBEEZ_CONFIG_TOUR_DISABLED_LINK'); ?>
        </a>
        <br>
        <?php echo mh_lng('MAILBEEZ_CONFIG_TOUR_DISABLED_TEXT'); ?>
    </div>

<?php
if (!mh_cfg('MAILBEEZ_CUSTOMER_INSIGHT_LOADED')) {
    mh_define('MAILBEEZ_CUSTOMER_INSIGHT_NOT_INSTALLED', true);
    if (file_exists(MH_DIR_CONFIG . 'config_customer_insight/includes/admin_footer_include.php')) {
        require(MH_DIR_CONFIG . 'config_customer_insight/includes/admin_footer_include.php');
    }
}