<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

mh_define('MAILBEEZ_DASHBOARD_ACTIONS_CONTENT', '
    <div id="WidgetTitle">' . mh_lng('MAILBEEZ_DASHBOARD_ACTIONS_TITLE') . '</div>
    <div id="WidgetSubTitle">' . mh_lng('MAILBEEZ_DASHBOARD_ACTIONS_TEXT') . '</div>
	<ul class="actions">
		<li class="actions_item item_mailbeez"><a href="' . mh_href_link(FILENAME_MAILBEEZ, 'tab=mailbeez') . '"><div class="actions_item_img"></div></a><div class="actions_item"><a href="' . mh_href_link(FILENAME_MAILBEEZ, 'tab=mailbeez') . '"><b>' . mh_lng('MH_TAB_MAILBEEZ') . '</b></a><br />' . mh_lng('MAILBEEZ_DASHBOARD_ACTIONS_MAILBEEZ_TEXT') . '</div></li>
		<li class="actions_item item_filterbeez"><a href="' . mh_href_link(FILENAME_MAILBEEZ, 'tab=filterbeez') . '"><div class="actions_item_img"></div></a><div class="actions_item"><a href="' . mh_href_link(FILENAME_MAILBEEZ, 'tab=filterbeez') . '"><b>' . mh_lng('MH_TAB_FILTER') . '</b></a><br />' . mh_lng('MAILBEEZ_DASHBOARD_ACTIONS_FILTER_TEXT') . '</div></li>
		<li class="actions_item item_reportbeez"><a href="' . mh_href_link(FILENAME_MAILBEEZ, 'tab=reportbeez') . '"><div class="actions_item_img"></div></a><div class="actions_item"><a href="' . mh_href_link(FILENAME_MAILBEEZ, 'tab=reportbeez') . '"><b>' . mh_lng('MH_TAB_REPORT') . '</b></a><br />' . mh_lng('MAILBEEZ_DASHBOARD_ACTIONS_REPORT_TEXT') . '</div></li>
		<li class="actions_item item_configbeez"><a href="' . mh_href_link(FILENAME_MAILBEEZ, 'tab=configbeez') . '"><div class="actions_item_img"></div></a><div class="actions_item"><a href="' . mh_href_link(FILENAME_MAILBEEZ, 'tab=configbeez') . '"><b>' . mh_lng('MH_TAB_CONFIGURATION') . '</b></a><br />' . mh_lng('MAILBEEZ_DASHBOARD_ACTIONS_CONFIGURATION_TEXT') . '</div></li>
	</ul>');

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/dashboardbeez.php');

class dashboard_actions extends dashboardbeez
{

    var $code;
    var $module;
    var $title;
    var $description;
    var $sort_order;
    var $enabled = false;

    function __construct()
    {
        parent::__construct();
        $this->code = 'dashboard_actions';
        $this->module = 'dashboard_actions';
        $this->version = '1.2'; // float value
        $this->required_mb_version = 2.1;
        $this->title = mh_lng('MAILBEEZ_DASHBOARD_ACTIONS_TITLE');
        $this->description = mh_lng('MAILBEEZ_DASHBOARD_ACTIONS_DESCRIPTION');
        $this->status_key = 'MAILBEEZ_DASHBOARD_ACTIONS_STATUS';

        if (mh_cfg('MAILBEEZ_DASHBOARD_ACTIONS_STATUS')) {
            $this->sort_order = mh_cfg('MAILBEEZ_DASHBOARD_ACTIONS_SORT_ORDER');
            $this->enabled = mh_cfg('MAILBEEZ_DASHBOARD_ACTIONS_STATUS') == 'True';
        }
        if ($this->modeSaas()) {
        }
            $this->enabled = false;
            $this->hidden = true;
    }



    function getOutput()
    {
        $output = '<link rel="stylesheet" type="text/css" media="print, projection, screen" href="' . mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'dashboardbeez/dashboard_actions/dashboard_actions.css" >';
        $output .= mh_lng('MAILBEEZ_DASHBOARD_ACTIONS_CONTENT');

        return $output;
    }


    function install()
    {
        mh_insert_config_value(array('configuration_title' => 'Show MailBeez Actions',
            'configuration_key' => 'MAILBEEZ_DASHBOARD_ACTIONS_STATUS',
            'configuration_value' => 'True',
            'configuration_description' => 'Do you want to show the MailBeez Actions on the dashboard? (recommended)',
            'set_function' => 'mh_cfg_select_option(array(\'True\', \'False\'), '
        ));

        mh_insert_config_value(array('configuration_title' => 'Sort order of display.',
            'configuration_key' => 'MAILBEEZ_DASHBOARD_ACTIONS_SORT_ORDER',
            'configuration_value' => '20',
            'configuration_description' => 'Sort order of display. Lowest is displayed first.',
            'set_function' => ''
        ));
    }

    function keys()
    {
        return array('MAILBEEZ_DASHBOARD_ACTIONS_STATUS', 'MAILBEEZ_DASHBOARD_ACTIONS_SORT_ORDER');
    }

}

