<?php

/*
  $Id$

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2010 osCommerce

  Released under the GNU General Public License
 */

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/dashboardbeez.php');

class dashboard_latest_news extends dashboardbeez
{

    var $code;
    var $module;
    var $title;
    var $description;
    var $sort_order;
    var $enabled = false;

    function __construct()
    {
        parent::__construct();
        $this->code = 'dashboard_latest_news';
        $this->module = 'dashboard_latest_news';
        $this->version = '3.0'; // float value
        $this->required_mb_version = 2.0;
        $this->title = mh_lng('MAILBEEZ_DASHBOARD_LATEST_NEWS_TITLE');
        $this->description = mh_lng('MAILBEEZ_DASHBOARD_LATEST_NEWS_DESCRIPTION');
        $this->status_key = 'MAILBEEZ_DASHBOARD_LATEST_NEWS_STATUS';
        $this->stripHTML = true;

        if (mh_cfg('MAILBEEZ_DASHBOARD_LATEST_NEWS_STATUS')) {
            $this->sort_order = mh_cfg('MAILBEEZ_DASHBOARD_LATEST_NEWS_SORT_ORDER');
            $this->enabled = (mh_cfg('MAILBEEZ_DASHBOARD_LATEST_NEWS_STATUS') == 'True');
        }
        if ($this->modeSaas()) {
             $this->enabled = false;
             $this->hidden = true;
         }
    }

    function dashboard_latest_news()
    {
        self::__construct();
    }

    function getOutput()
    {
        if (!class_exists('lastRSS')) {
            include(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/' . 'rss.php');
        }

        $rss = new lastRSS;
        $rss->items_limit = 20;
        $rss->cache_dir = mh_cfg('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_COMPILE_DIR');
        $rss->cache_time = 3600; //86400;


//        $feed_url_en = 'http://feeds.feedburner.com/MailbeezNews';
//        $feed_url_de = 'http://feeds.feedburner.com/MailbeezNewsDE';

        $feed_url_en = 'https://www.mailbeez.com/newsfeed.rss';
        $feed_url_de = 'https://www.mailbeez.de/newsfeed.rss';

        $feed_url = '';

        switch ($_SESSION['language']) {
            case "german":
                $feed_url = $feed_url_de;
                break;
            default:
                $feed_url = $feed_url_en;
        }

        $feed = $rss->get($feed_url);

        $output = '<div id="WidgetTitle">' . mh_lng('MAILBEEZ_DASHBOARD_LATEST_NEWS_TITLE') . '</div>
                   <div id="WidgetSubTitle">' . mh_lng('MAILBEEZ_DASHBOARD_LATEST_NEWS_TEXT') . '</div>';
        $output .= '<table style="margin-top: 5px; border="0" width="100%" cellspacing="0" cellpadding="4">' .
            '  <tr class="dataTableHeadingRow">' .
            '    <td class="dataTableHeadingContent">' . mh_lng('MAILBEEZ_DASHBOARD_LATEST_NEWS_TITLE') . '</td>' .
            '    <td class="dataTableHeadingContent" align="right">' . mh_lng('MAILBEEZ_DASHBOARD_LATEST_NEWS_DATE') . '</td>' .
            '  </tr>' .
            '</table>';

        $output .= '<div style="overflow: auto; height: 142px; border:">';
        $output .= '<table style="margin-top: 0px;" border="0" width="100%" cellspacing="0" cellpadding="4">';

        if (is_array($feed) && !empty($feed)) {
            foreach ($feed['items'] as $item) {
                $title_str = (strtolower(mh_cfg('CHARSET')) == 'utf-8') ? ($item['title']) : utf8_decode($item['title']);

                $output .= '  <tr class="dataTableRow" onmouseover="rowOverEffect(this);" onmouseout="rowOutEffect(this);">' .
                    '    <td class="dataTableContent"><a href="' . $item['link'] . '" target="_blank">' . $title_str . '</a></td>' .
                    '    <td class="dataTableContent" align="right" style="white-space: nowrap;">' . date("F j, Y", strtotime($item['pubDate'])) . '</td>' .
                    '  </tr>';
            }
        } else {
            $output .= '  <tr class="dataTableRow">' .
                '    <td class="dataTableContent" colspan="2">' . mh_lng('MAILBEEZ_DASHBOARD_LATEST_NEWS_FEED_ERROR') . '</td>' .
                '  </tr>';
        }


        /*
$output .= '  <tr class="dataTableRow">' .
'    <td class="dataTableContent" align="right" colspan="2"><a href="http://www.oscommerce.com/newsletter/subscribe" target="_blank">' . tep_image(DIR_WS_IMAGES . 'icon_newsletter.png', MAILBEEZ_DASHBOARD_LATEST_NEWS_ICON_NEWSLETTER) . '</a>&nbsp;<a href="http://www.facebook.com/pages/osCommerce/33387373079" target="_blank">' . tep_image(DIR_WS_IMAGES . 'icon_facebook.png', MAILBEEZ_DASHBOARD_LATEST_NEWS_ICON_FACEBOOK) . '</a>&nbsp;<a href="http://twitter.com/osCommerce" target="_blank">' . tep_image(DIR_WS_IMAGES . 'icon_twitter.png', MAILBEEZ_DASHBOARD_LATEST_NEWS_ICON_TWITTER) . '</a>&nbsp;<a href="http://feeds.feedburner.com/osCommerceNewsAndBlogs" target="_blank">' . tep_image(DIR_WS_IMAGES . 'icon_rss.png', MAILBEEZ_DASHBOARD_LATEST_NEWS_ICON_RSS) . '</a></td>'; */

        $output .= '  </tr>' .
            '</table>';

        $output .= '</div>';
        return $output;
    }


    function install()
    {
        mh_insert_config_value(array('configuration_title' => 'Enable Latest MailBeez News Module',
            'configuration_key' => 'MAILBEEZ_DASHBOARD_LATEST_NEWS_STATUS',
            'configuration_value' => 'True',
            'configuration_description' => 'Do you want to show the latest MailBeez News on the dashboard?',
            'set_function' => 'mh_cfg_select_option(array(\'True\', \'False\'), '
        ));

        mh_insert_config_value(array('configuration_title' => 'Sort order of display.',
            'configuration_key' => 'MAILBEEZ_DASHBOARD_LATEST_NEWS_SORT_ORDER',
            'configuration_value' => '35',
            'configuration_description' => 'Sort order of display. Lowest is displayed first.',
            'set_function' => ''
        ));
    }

    function keys()
    {
        return array('MAILBEEZ_DASHBOARD_LATEST_NEWS_STATUS', 'MAILBEEZ_DASHBOARD_LATEST_NEWS_SORT_ORDER');
    }

}

?>
