<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/dashboardbeez.php');

class dashboard_newsletter2go extends dashboardbeez
{

    var $code;
    var $module;
    var $title;
    var $description;
    var $sort_order;
    var $enabled = false;

    function __construct()
    {
        parent::__construct();
        $this->code = 'dashboard_newsletter2go';
        $this->module = 'dashboard_newsletter2go';
        $this->version = '0.1'; // float value
        $this->required_mb_version = 2.7;
        $this->title = mh_lng('MAILBEEZ_DASHBOARD_NEWSLETTER2GO_API_TITLE');
        $this->description = mh_lng('MAILBEEZ_DASHBOARD_NEWSLETTER2GO_API_DESC');
        $this->description_image = '';
        $this->icon = '';
        //$this->removable = false; // can't be removed
        $this->enabled = ((mh_cfg('MAILBEEZ_DASHBOARD_NEWSLETTER2GO_API_STATUS') == 'True') ? true : false);
        $this->status_key = 'MAILBEEZ_DASHBOARD_NEWSLETTER2GO_API_STATUS';
        $this->documentation_root = 'https://www.mailbeez.com/documentation/dashboardbeez/';
        $this->documentation_key = $this->module;

        $this->admin_action_plugins_path = MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'dashboardbeez/'; // default-path to include admin action plugins from
        $this->admin_action_plugins = '';

        $this->sort_order = mh_cfg('MAILBEEZ_DASHBOARD_NEWSLETTER2GO_API_SORT_ORDER');
        $this->hidden = true;
    }

    function dashboard_newsletter2go()
    {
        self::__construct();
    }

    function generateData()
    {
        // collect data


        // caching

        $data = array();
        return $data;

    }

    function getOutput()
    {

        $data = $this->generateData();

        // next version: ajax loading to avoid slow down

        ob_start();
        ?>
        <div id="WidgetTitle"><?php echo MAILBEEZ_DASHBOARD_NEWSLETTER2GO_API_TITLE ?></div>
        <div id="WidgetSubTitle"><?php echo mh_lng('MAILBEEZ_DASHBOARD_NEWSLETTER2GO_API_DESC'); ?></div>

        <div id="democontent-for-christian" style="opacity: 0.5">

            This widget shows the trend for revenue generated by MailBeez.
            <br>
            MailBeez Tracks orders following a click on a email link in TABLE_MAILBEEZ_TRACKING_ORDERS
            <br/>
            check the code of this modules for more information
            <br/>
            <br/>
            <!--
            <br/>
            revenue this month to date vs. revenue last month
            <br/>
            revenue this year to date vs. revenue last year
            <br/>
            forecast / trend up / down

            see http://www.geckoboard.com/ for visualisation ideas
    -->
            <?php
            $string = "EUR 10%";
            $string = (int)preg_replace("/[^0-9]/", "", $string);

            echo $string;
            ?>
            <table style="width: 100%" cellspacing="0">
                <tr valign="top">
                    <td style="border-right: 1px solid #c0c0c0">Month</td>
                    <td></td>
                    <td>Year</td>
                </tr>
                <tr valign="top">
                    <td style="border-right: 1px solid #c0c0c0">
                        <table style="width: 100%" cellspacing="0">
                            <tr valign="top">
                                <td>last month
                                    <br/>
                                    <?php echo mh_price(100); ?>
                                </td>
                                <td>this month (^|v)
                                    <br>current <?php echo mh_price(100); ?>
                                    <br>forecast <?php echo mh_price(200); ?>
                                    <br>+100%
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td></td>
                    <td>
                        <table style="width: 100%" cellspacing="0">
                            <tr valign="top">
                                <td>last year</td>
                                <td>this year (^|v)
                                    <br>current
                                    <br>forecast
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>

        <?php
        $output = ob_get_contents();
        ob_end_clean();

        return $output;
    }


    function install()
    {
        mh_insert_config_value(array('configuration_title' => 'Show MailBeez KPI Revenue',
            'configuration_key' => 'MAILBEEZ_DASHBOARD_NEWSLETTER2GO_API_STATUS',
            'configuration_value' => 'True',
            'configuration_description' => 'Do you want to show the MailBeez KPI Revenue on the dashboard? (recommended)',
            'set_function' => 'mh_cfg_select_option(array(\'True\', \'False\'), '
        ));

        mh_insert_config_value(array('configuration_title' => 'Sort order of display.',
            'configuration_key' => 'MAILBEEZ_DASHBOARD_NEWSLETTER2GO_API_SORT_ORDER',
            'configuration_value' => '40',
            'configuration_description' => 'Sort order of display. Lowest is displayed first.',
            'set_function' => ''
        ));
    }


    function keys()
    {
        return array('MAILBEEZ_DASHBOARD_NEWSLETTER2GO_API_STATUS', 'MAILBEEZ_DASHBOARD_NEWSLETTER2GO_API_SORT_ORDER');
    }

}
