<?php
/*
  $Id$

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2010 osCommerce

  Released under the GNU General Public License
*/

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/dashboardbeez.php');
require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/email_engine_php_mailer.php');
require_once(mh_cfg('MH_DIR_CONFIG') . 'config_email_engine.php');

class dashboard_status extends dashboardbeez
{
    var $code;
    var $module;
    var $title;
    var $description;
    var $sort_order;
    var $enabled = false;

    function __construct()
    {
        parent::__construct();
        $this->code = 'dashboard_status';
        $this->module = 'dashboard_status';
        $this->version = '1.1'; // float value
        $this->required_mb_version = 2.2;
        $this->title = mh_lng('MAILBEEZ_DASHBOARD_STATUS_TITLE');
        $this->description = mh_lng('MAILBEEZ_DASHBOARD_STATUS_DESCRIPTION');
        $this->status_key = 'MAILBEEZ_DASHBOARD_STATUS_STATUS';
        $this->hidden = true;

        if (mh_cfg('MAILBEEZ_DASHBOARD_STATUS_STATUS')) {
            $this->sort_order = mh_cfg('MAILBEEZ_DASHBOARD_STATUS_SORT_ORDER');
            $this->enabled = (mh_cfg('MAILBEEZ_DASHBOARD_STATUS_STATUS') == 'True');
        }
        $this->set_cache_id($this->code, 'dashboard_status');

    }

    function generateData($refresh = false)
    {
        $this->set_cache_id($this->code, 'dashboard_status');

        if (!$refresh && $cache = $this->read_cache("app", true)) {
            return $cache['value'];
        }

        require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez_system.php');

        $data = mailbeez_system::getSystemStatusData();

        return $this->set_cache($data, 'app'); // session | request | app

    }

    function generateOutput($ajax = false, $refresh = false)
    {
        mh_load_modules_language_files(MH_DIR_CONFIG, 'config_email_engine_n2g');
        if ($refresh) {
            // purge cache of notifications as well
            require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'dashboardbeez/dashboard_status/viewbeez/view_status.php');
            $view_status = new view_status();
            $view_status->purgeDataCache();
        }

        $data = $this->generateData($refresh);

        $smarty = new mh_Smarty;
        $smarty->setTemplateDir(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'dashboardbeez/dashboard_status/templates/');
        $smarty->setCompileId('stats_system');
        $smarty->setConfigDir(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'dashboardbeez/dashboard_status/languages/');
        list($smarty_config_dir) = $smarty->getConfigDir();

// lngrefactor


        if (file_exists($smarty->getConfigDir(0) . $_SESSION['language'] . '.conf')) {
            $smarty->assign('language', $_SESSION['language']);
        } else {
            $smarty->assign('language', 'english');
        }

        $smarty->assign($data);
        $output = $smarty->fetch('status_system.tpl');


        return $output;
    }

    function install()
    {
        mh_insert_config_value(array('configuration_title' => 'Show MailBeez System Status',
            'configuration_key' => 'MAILBEEZ_DASHBOARD_STATUS_STATUS',
            'configuration_value' => 'True',
            'configuration_description' => 'Do you want to show the MailBeez System Status on the dashboard? (recommended)',
            'set_function' => 'mh_cfg_select_option(array(\'True\', \'False\'), '
        ));

        mh_insert_config_value(array('configuration_title' => 'Sort order of display.',
            'configuration_key' => 'MAILBEEZ_DASHBOARD_STATUS_SORT_ORDER',
            'configuration_value' => '0',
            'configuration_description' => 'Sort order of display. Lowest is displayed first.',
            'set_function' => ''
        ));

    }

    function keys()
    {
        return array('MAILBEEZ_DASHBOARD_STATUS_STATUS', 'MAILBEEZ_DASHBOARD_STATUS_SORT_ORDER');
    }
}

