<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/viewbeez.php');


class view_status extends viewbeez
{

    var $config_email_engine_link;
    var $dashboard_link;
    var $n2go_topup_link;
    var $data;

// class constructor
    function __construct()
    {
        parent::__construct();

        $this->code = 'view_status';
        $this->module = 'view_status';
        $this->version = '1.0';
        $this->title = mh_lng('MAILBEEZ_VIEW_STATUS_TITLE');
        $this->description = mh_lng('MAILBEEZ_VIEW_STATUS_DESCRIPTION');

        $this->sort_order = 300;
//        $this->enabled = (('Newsletter2Go' == MAILBEEZ_CONFIG_EMAIL_ENGINE) && (MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_API_VERSION == 'v2') ? true : false);
        $this->set_template();
        $this->has_dashboard_view = false;

        $this->hidden = true;
                $this->viewpage = mh_get('view_page', 'overview');


        $this->config_email_engine_link = mh_href_link(FILENAME_MAILBEEZ, 'module=config_email_engine');
        $this->dashboard_link = mh_href_link(FILENAME_MAILBEEZ, '');

        $this->app_cache_time = 15 * 60;
        $this->panel_ajax_refresh = true;

    }

    function view_status()
    {
        self::__construct();
    }

    function set_context($context)
    {
        if ($context == 'panel') {
            $this->sort_order = 3;
        }
    }


    function get_view_content($template)
    {
        return false;
    }


    function get_view_summary()
    {
        return false;
    }


    function get_view_dashboard_widget()
    {
        return false;
    }


    function get_view_dashboard_content($template)
    {
        return false;

    }

    function getData()
    {
        if (is_array($this->data)) {
            return $this->data;
        }

        $this->set_cache_id('status_data', 'view_status');

        if ($cache = $this->read_cache('app')) {
            $this->data = $cache['value'];
            return $this->data;
        }

        require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez_system.php');
        $this->data = mailbeez_system::getSystemStatusData();
        return $this->set_cache($this->data, 'app');
    }


    public function data_update()
    {
        $data = $this->getData();

//        $this->set_cache_id('crm_panel', 'view_status');
//        $this->purge_cache('app');
//        $this->set_cache_id('global', 'status_data');
//        $this->purge_cache('app');

        $this->notficationsObj = new notificationbeez();

        $icon_alert = 'background-image: url(' . mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'dashboardbeez/dashboard_status/viewbeez/icon.png); background-color: #da4f49';
        $icon_warning = 'background-image: url(' . mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'dashboardbeez/dashboard_status/viewbeez/icon.png); background-color: #f8933c';

        $subscription_code = 'subscription';
        $n2go_code = 'n2go';
        $email_code = 'emailserver';
        $system_code = 'system';

        if ($data['system']['status'] == 'OK') {
            $this->notficationsObj->deleteNotification($system_code);

        } else {
            $this->notficationsObj->deleteNotification($system_code, 1); // 1 notification per day

            $notification = array('module' => $system_code,
                'ref_id' => date("Ymd"), // once a day
                'iteration' => 1,
                'customers_id' => null,
                'severity' => 2,
                'link' => $this->dashboard_link,
                'link_type' => 'I', // E - external, I - internal, P - popup
                'panel_click_action' => 'H', // H - hide
                'channel_id' => 0,
                'status' => '0',
                'icon_style' => $icon_warning);

            switch ($data['system']['status']) {

                case 'INIT':
                    break;
                case 'CHECK':
                    $this->notficationsObj->deleteNotification($system_code, 1); // 1 notification per day
                    $notification['title'] = MAILBEEZ_CONFIG_NOTIFICATION_CHECK_TITLE;
                    $notification['notification_summary'] = MAILBEEZ_CONFIG_NOTIFICATION_CHECK_TEXT;
                    $notification['notification'] = MAILBEEZ_CONFIG_NOTIFICATION_CHECK_TEXT;
                    $notification['severity'] = 2;
                    $notification['icon_style'] = $icon_warning;


                    $this->notficationsObj->add($notification);
                    break;

            }

        }


        // Subscription

        if ($data['subscription']['is_pro'] && !mh_saas()) {
            if ($data['subscription']['data']['status'] == 'OK') {
                $this->notficationsObj->deleteNotification($subscription_code);

            } else {
                $this->notficationsObj->deleteNotification($subscription_code, 1); // 1 notification per day
                mh_load_modules_language_files(MH_DIR_CONFIG, 'config_cloudbeez');

                $notification = array('module' => $subscription_code,
                    'ref_id' => date("Ymd"), // once a day
                    'iteration' => 1,
                    'customers_id' => null,
                    'severity' => 2,
                    'link' => $this->dashboard_link,
                    'link_type' => 'I', // E - external, I - internal, P - popup
                    'panel_click_action' => 'H', // H - hide
                    'channel_id' => 0,
                    'status' => '0',
                    'icon_style' => $icon_warning);

                switch ($data['subscription']['data']['value']['message']) {
                    case 'WARNING_EXPIRED':
                        $data['subscription']['data']['status']; // ERROR
                        $notification['title'] = MAILBEEZ_CONFIG_CLOUDBEEZ_EXPIRED_TITLE;
                        $notification['notification_summary'] = MAILBEEZ_CONFIG_CLOUDBEEZ_EXPIRED_TEXT;
                        $notification['notification'] = MAILBEEZ_CONFIG_CLOUDBEEZ_EXPIRED_TEXT;
                        $notification['severity'] = 1;
                        $notification['icon_style'] = $icon_alert;
                        break;

                    case 'ERROR_EXCEED_CUSTOMER_CNT':
                        $data['subscription']['data']['status']; // ERROR
                        $notification['title'] = MAILBEEZ_CONFIG_CLOUDBEEZ_EXCEED_CUSTOMER_CNT_TITLE;
                        $notification['notification_summary'] = MAILBEEZ_CONFIG_CLOUDBEEZ_EXCEED_CUSTOMER_CNT_TEXT;
                        $notification['notification'] = MAILBEEZ_CONFIG_CLOUDBEEZ_EXCEED_CUSTOMER_CNT_TEXT;
                        $notification['severity'] = 1;
                        $notification['icon_style'] = $icon_alert;
                        break;

                    case 'WARNING_EXPIRES_SOON':
                        $data['subscription']['data']['status']; // WARNING

                        $notification['title'] = MAILBEEZ_CONFIG_CLOUDBEEZ_EXPIRES_SOON_TITLE;
                        $notification['notification_summary'] = MAILBEEZ_CONFIG_CLOUDBEEZ_EXPIRES_SOON_TEXT;
                        $notification['notification'] = MAILBEEZ_CONFIG_CLOUDBEEZ_EXPIRES_SOON_TEXT;
                        $notification['severity'] = 2;
                        $notification['icon_style'] = $icon_warning;
                        break;

                    case 'WARNING_CUSTOMER_CNT':
                        $data['subscription']['data']['status']; // WARNING

                        $notification['title'] = MAILBEEZ_CONFIG_CLOUDBEEZ_CUSTOMER_CNT_LIMIT_TITLE;
                        $notification['notification_summary'] = MAILBEEZ_CONFIG_CLOUDBEEZ_CUSTOMER_CNT_LIMIT_TEXT;
                        $notification['notification'] = MAILBEEZ_CONFIG_CLOUDBEEZ_CUSTOMER_CNT_LIMIT_TEXT;
                        $notification['severity'] = 2;
                        $notification['icon_style'] = $icon_warning;
                        break;
                }
                $this->notficationsObj->add($notification);
            }
        }


        // Email Engine

        if ($data['status_mlbz_email_active'] && !mh_saas()) {
            // todo
            // on premises
            // warnings for low credits and more
        } elseif ($data['status_n2go_active'] && !mh_saas()) {
            if ($data['n2go_data']['status'] == 'OK') {
                $this->notficationsObj->deleteNotification($n2go_code);
            } else {
                mh_load_modules_language_files(MH_DIR_CONFIG, 'config_email_engine_n2g');
                if (mh_cfg('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_API_VERSION') == 'v1') {
                    $this->n2go_topup_link = mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_LOAD_URL');
                } else {
                    $this->n2go_topup_link = mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_V2_LOAD_URL');
                }


                $this->notficationsObj->deleteNotification($n2go_code, 1); // 1 notification per day
                $set_notification = false;


                $notification = array('module' => $n2go_code,
                    'ref_id' => date("Ymd"), // once a day
                    'iteration' => 1,
                    'customers_id' => null,
                    'severity' => 2,
                    'link' => $this->n2go_topup_link,
                    'link_type' => 'E', // E - external, I - internal, P - popup
                    'panel_click_action' => 'H', // H - hide
                    'channel_id' => 0,
                    'status' => '0',
                    'icon_style' => $icon_alert);

                if ($data['n2go_data']['msg'] == 'LOW_CREDITS') {
                    $notification['ref_id'] = date("Ymd") . '01'; // once a day;
                    $notification['title'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_LOW_CREDITS_TITLE;
                    $notification['notification_summary'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_LOW_CREDITS_TEXT;
                    $notification['notification'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_LOW_CREDITS_TEXT;
                    $notification['severity'] = 2;
                    $notification['icon_style'] = $icon_warning;
                    $set_notification = true;
                } else {
                    $this->notficationsObj->deleteNotification($n2go_code, 0, date("Ymd") . '01'); // 1 notification per day
                }
                if ($data['n2go_data']['msg'] == 'NO_CREDITS') {
                    $notification['ref_id'] = date("Ymd") . '02'; // once a day;
                    $notification['title'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_LOW_CREDITS_TITLE;
                    $notification['notification_summary'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_LOW_CREDITS_TEXT;
                    $notification['notification'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_LOW_CREDITS_TEXT;
                    $notification['severity'] = 1;
                    $set_notification = true;
                } else {
                    $this->notficationsObj->deleteNotification($n2go_code, 0, date("Ymd") . '02'); // 1 notification per day
                }
                if ($data['n2go_data']['msg'] == 'SPF_WARNING') {
                    $notification['ref_id'] = date("Ymd") . '03'; // once a day;
                    $notification['title'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_SPF_WARNING_TITLE;
                    $notification['notification_summary'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_SPF_WARNING_TEXT;
                    $notification['notification'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_SPF_WARNING_TEXT;
                    $notification['severity'] = 2;
                    $notification['link'] = $data['n2go_data']['config_url'];
                    $notification['link_type'] = 'I'; // E - external, I - internal, P - popup
                    $notification['icon_style'] = $icon_warning;
                    $set_notification = true;
                } else {
                    $this->notficationsObj->deleteNotification($n2go_code, 0, date("Ymd") . '03'); // 1 notification per day
                }
                if ($data['n2go_data']['msg'] == 'INTEGRATION_ERROR') {
                    $notification['ref_id'] = date("Ymd") . '04'; // once a day;
                    $notification['title'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_INTEGRATION_ERROR_TITLE;
                    $notification['notification_summary'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_INTEGRATION_ERROR_TEXT;
                    $notification['notification'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_INTEGRATION_ERROR_TEXT;
                    $notification['severity'] = 1;
                    $notification['link'] = $data['n2go_data']['config_url'];
                    $notification['link_type'] = 'I'; // E - external, I - internal, P - popup
                    $set_notification = true;
                } else {
                    $this->notficationsObj->deleteNotification($n2go_code, 0, date("Ymd") . '04'); // 1 notification per day
                }
                if ($data['n2go_data']['msg'] == 'INTEGRATION_UPGRADE_AVAILABLE') {
                    $notification['ref_id'] = date("Ymd") . '05'; // once a day;
                    $notification['title'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_UPGRADE_AVAILABLE_TITLE;
                    $notification['notification_summary'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_UPGRADE_AVAILABLE_TEXT;
                    $notification['notification'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NOTIFICATION_UPGRADE_AVAILABLE_TEXT;
                    $notification['severity'] = 2;
                    $notification['link'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_UPGRADE_URL;
                    $notification['link_type'] = 'E'; // E - external, I - internal, P - popup
                    $set_notification = true;
                } else {
                    $this->notficationsObj->deleteNotification($n2go_code, 0, date("Ymd") . '05'); // 1 notification per day
                }


                if ($set_notification) {

                    $this->notficationsObj->add($notification);
                }
            }
        } else {
            if ($data['email_status']['status'] == 'OK') {
                $this->notficationsObj->deleteNotification($email_code);

            } elseif ($data['email_status']['status'] == 'ERROR') {
                $this->notficationsObj->deleteNotification($email_code, 1); // 1 notification per day
                mh_load_modules_language_files(MH_DIR_CONFIG, 'config_email_engine', MH_FILE_EXTENSION);

                $notification = array('module' => $email_code,
                    'ref_id' => date("Ymd"), // once a day
                    'iteration' => 1,
                    'customers_id' => null,
                    'severity' => 1,
                    'link' => $this->config_email_engine_link,
                    'link_type' => 'I', // E - external, I - internal, P - popup
                    'panel_click_action' => 'H', // H - hide
                    'channel_id' => 0,
                    'status' => '0',
                    'icon_style' => $icon_alert);

                $notification['title'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_NOTIFICATION_ERROR_TITLE;
                $notification['notification_summary'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_NOTIFICATION_ERROR_TEXT;
                $notification['notification'] = MAILBEEZ_CONFIG_EMAIL_ENGINE_NOTIFICATION_ERROR_TEXT;
                $this->notficationsObj->add($notification);
            }


            // shop or smtp server
        }

        $credits = 0;


    }

    function get_view_panel()
    {
        return false;

        $data = $this->getData();

        if ($data['status_summary'] == 'OK') {
            return false;
        }


        $smarty = $this->init_view_panel($this->module);

        $smarty->assign(array(
                'dashboard_link' => $this->dashboard_link,
                'config_email_engine_link' => $this->config_email_engine_link
            )
        );

        $content = $this->parse_view_panel($smarty);

        $this->set_cache_id('crm_panel', 'view_status');
        return $this->set_cache($content, 'app');

    }

    function purgeDataCache()
    {
        $this->set_cache_id('status_data', 'view_status');
        return $this->purge_cache('app');
    }
}
