<?php
/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011, 2012 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

// make path work from admin
require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez.php');

class service_handler_bounce_ubvx extends mailbeez
{
    // class constructor
    function __construct()
    {
        // call constructor
        parent::__construct();

        // set some stuff:
        $this->code = 'service_handler_bouncehive_ubvx';
        $this->module = 'service_handler_bouncehive_ubvx';
        $this->version = 4.0; // float value
        $this->required_mb_version = 4.6; // required mailbeez version
        $this->iteration = 1;
        $this->title = mh_lng('MAILBEEZ_BOUNCEHIVE_HNDL_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_BOUNCEHIVE_HNDL_TEXT_DESCRIPTION');
        $this->sort_order = 20000;
        $this->enabled = true; ( 'mlbz_ubvx' == mh_cfg('MAILBEEZ_CONFIG_EMAIL_ENGINE')) ;
        $this->admin_action_plugins = '';
        $this->common_admin_action_plugins = '';
        $this->is_editable = false; // allow editor
        $this->is_configurable = false;
        $this->removable = false;
        $this->hidden = true;

        $this->allow_preview = false;
        $this->allow_reporting = false;
        $this->allow_timing = false;
        $this->allow_group_filter_check = false;

    }

    function service_handler_bouncehive()
    {
        self::__construct();
    }

// class methods
    function getAudience()
    {
        return false;
    }



    function check()
    {
        return true;
    }
    function remove()
    {
        return false;
    }

    function install()
    {
        return false;
    }

    function process($audience = '', $mode = '')
    {
        return -1;
    }


    function external_bounce_process($external_call = 'True')
    {
        if (!$this->enabled || !isset($_POST) || !is_array($_POST) || sizeof($_POST) == 0) {
            header('HTTP/1.1 400 Bad Request');
            mh_exit();
        }
        if (isset($_POST['data'])) {

            $data = json_decode(stripslashes($_POST['data']), true);
            $time = $_POST['time'];
            $data['time'] = $time;
            require_once(MH_DIR_CONFIG . 'config_email_engine.php');
            config_email_engine::trackBounce($data);
        }
        echo "done";
        mh_exit();
    }

}
