<?php
/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2014 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

  v2.9.6
 */

///////////////////////////////////////////////////////////////////////////////
///																		     //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////


require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez.php');

class service_sync_newsletter_xtc extends mailbeez
{
    // class constructor
    function __construct()
    {
        // call constructor
        parent::__construct();

        // set some stuff:
        $this->code = 'service_sync_newsletter_xtc';
        $this->module = 'service_sync_newsletter_xtc';
        $this->version = 4.1; // float value
        $this->required_mb_version = 2.99; // required mailbeez version
        $this->iteration = 1;
        $this->title = mh_lng('MAILBEEZ_SYNC_NL_XTC_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_SYNC_NL_XTC_TEXT_DESCRIPTION');
        $this->documentation_key = $this->module;

        $this->sort_order = -1;
        $this->admin_action_plugins = 'process.php';
        $this->common_admin_action_plugins = '';
        $this->status_key = 'MAILBEEZ_SYNC_NL_XTC_STATUS';

        $this->enabled = (defined('TABLE_NEWSLETTER_RECIPIENTS') && (mh_cfg('MAILBEEZ_SYNC_NL_XTC_STATUS') == 'True') ? true : false);
        $this->hidden = !defined('TABLE_NEWSLETTER_RECIPIENTS');

        $this->is_editable = false; // allow editor
        $this->is_configurable = true;
        $this->removable = false;
        $this->allow_preview = false;
        $this->allow_reporting = false;
        $this->allow_timing = false;
        $this->allow_group_filter_check = false;


        if (!$this->hidden) {
            // self installing
            if (!mh_cfg($this->status_key)) {
                $this->install();
            } else {
                $this->check_update();
            }
        }

        if (mh_cfg('MAILBEEZ_NEWSLETTER_SUBSCRIBER_SUPPORT') == 'True') {
            $this->enabled = false;
            $this->hidden = true;
        }
    }

    function service_sync_newsletter_xtc()
    {
        self::__construct();
    }

// class methods

    function keys()
    {
        return array('MAILBEEZ_SYNC_NL_XTC_STATUS');
    }

    function getAudience()
    {
        return false;
    }


    function install()
    {

        // add index, check if index is already there
        if (!mh_db_check_index_on_column_exists(TABLE_CUSTOMERS, 'customers_email_address')) {
            mh_db_query("ALTER TABLE " . TABLE_CUSTOMERS . " ADD INDEX ( customers_email_address )");
        }


        if (defined('TABLE_NEWSLETTER_RECIPIENTS')) {
            if (!mh_db_check_index_on_column_exists(TABLE_NEWSLETTER_RECIPIENTS, 'customers_email_address')) {
                mh_db_query("ALTER TABLE " . TABLE_NEWSLETTER_RECIPIENTS . " ADD INDEX ( customers_email_address )");
            }
        }

        mh_insert_config_value(array('configuration_title' => 'installed',
            'configuration_key' => 'MAILBEEZ_SYNC_NL_XTC_STATUS',
            'configuration_value' => 'True',
            'configuration_description' => 'installed',
            'set_function' => 'mh_cfg_select_option(array(\'True\', \'False\'), '
        ));


        return false;
    }

    function process($audience = '', $mode = '')
    {
        $this->external_sync(false);
        return -1;
    }

    function external_sync($external = true)
    {
        if ($external) {
            echo $this->html_header();
        }

        if (!defined('TABLE_NEWSLETTER_RECIPIENTS')) {
            echo 'TABLE_NEWSLETTER_RECIPIENTS not found';
            return false;
        }

        // update all customers_newsletter status in TABLE_CUSTOMERS based on the information in TABLE_NEWSLETTER_RECIPIENTS
        $query_sql_raw = "update " . TABLE_CUSTOMERS . " c
                        left outer join " . TABLE_NEWSLETTER_RECIPIENTS . " n on (c.customers_email_address = n.customers_email_address)
                    set customers_newsletter = IF(n.mail_status = 1, 1, 0) ";
        //echo $query_sql_raw;

        $query_sql = mh_db_query($query_sql_raw);

        echo "done";
        if ($external) {
            echo $this->html_footer();
            mh_exit();
        }
    }
}
