<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez.php');

class winback_promo extends mailbeez
{

// class constructor
    function __construct()
    {
        // call constructor
        parent::__construct();

        $this->code = 'winback_promo';
        $this->module = 'winback_promo'; // same as folder name
        $this->version = '2.0'; // float value
        $this->title = mh_lng('MAILBEEZ_WINBACK_PROMO_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_WINBACK_PROMO_TEXT_DESCRIPTION');
        // Metadata for Beez UI
        $this->group = self::GROUP_RETENTION;
        // Icon: Heroicons Outline "Arrow Uturn Left"  represents win-back/reactivation
        // Source: https://heroicons.com/
        $this->svg_icon = '<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6"><path stroke-linecap="round" stroke-linejoin="round" d="M9 15L3 9m0 0l6-6M3 9h12a6 6 0 010 12h-3"/></svg>';
        // Tailwind color class used by UI
        $this->color = 'bg-indigo-600 text-white';
        if (mh_cfg('MAILBEEZ_WINBACK_ADVANCED_STATUS')
            || file_exists(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'mailbeez/winback_advanced.php')
        ) {
            $this->hidden = true;
        } else {
            $this->icon = '../../common/images/lock.png';
        }
        $this->removable = false; // can't be removed
        $this->stealth = true; // don't list as an installed module
        $this->sort_order = 1;
        $this->documentation_key = 'winback_advanced'; // leave empty if no documentation available
        $this->common_admin_action_plugins = '';
        $this->do_process = false; // a processable module
        $this->is_editable = false; // allow editor
        $this->is_configurable = false;

    }

    function winback_promo()
    {
        self::__construct();
    }

// class methods

    function getAudience()
    {
        return false;
    }

    function check()
    {
        return true;
    }

    function remove()
    {
        return false;
    }

    function install()
    {
        return false;
    }

}

