<?php

// add version information for deployment
class mailbeez_installer_dummy
{
    public $version;
    public $php_min;
    public $php_max_lt;
    public $php_max_output;

    function __construct()
    {
        $this->version = 5.2;
        $this->php_min = '7.3';
        $this->php_max_lt = '8.4';
        $this->php_max_output = '8.4.*';
    }

    public function versionCheck() {
        // Get the current PHP version
        $current_php_version = phpversion();

        // Check if the current PHP version is between php_min and php_max
        if (version_compare($current_php_version, $this->php_min, '>=') && version_compare($current_php_version, $this->php_max_lt, '<')) {
            return true; // PHP version is within the range
        } else {
            return false; // PHP version is out of range
        }
    }
}
$version = new mailbeez_installer_dummy();

if (!$version->versionCheck()) {
    include('cloudloader_version_warning.php'); exit();
}
// Version
define('CLOUDBEEZ_MAILBEEZ_INSTALLER_VERSION', $version->version);
define('CLOUDBEEZ_MAILBEEZ_INSTALLER_PHP_MIN', $version->php_min);
define('CLOUDBEEZ_MAILBEEZ_INSTALLER_PHP_MAX', $version->php_max_output);